$(function(){

	/* CUSTOM SCROLLBAR */
	$(window).on("load",function(){
		
		$(".sidebar, .modal").mCustomScrollbar({
			theme:"dark-3"
		});
		
	});

	/* SWITCH SALE AND ORDER TAB*/
	$('#product-tab').click(function(e){
		$('.product-list').show();
		$(this).addClass('active');
		$('#order-tab').removeClass('active');
		$('.order-list').hide();
	});
	$('#order-tab').click(function(e){
		e.preventDefault();
		$('.order-list').show();
		$(this).addClass('active');
		$('#product-tab').removeClass('active');
		$('.product-list').hide();
	});



	$('.dropdown-toggle').dropdown();

	$('.barcode-input input[type="text"]').focus();

	/* HIDDEN SEARCH BUTTON */
	var searchText = $(".top-navbar .search-box input[type='text']");
	$('.search-btn .ion-close-circled').hide();

	$('.search-btn .ion-ios-search').click(function(){
		searchText.show();
		$('.search-btn .ion-close-circled').show();
		$(this).hide();
	});
	$('.search-btn .ion-close-circled').click(function(){
		if(searchText.val() != ''){
			searchText.val('');
			searchText.focus();
		}
		else{
			$(searchText).hide();
			$(this).hide();
			$('.search-btn .ion-ios-search').show();
		}
	});
	$(searchText).blur(
	     function (event) {
	        if($(this).val() == ''){
	         	$(this).hide();
	         	$('.search-btn .ion-close-circled').hide();
	         	$('.search-btn .ion-ios-search').show();
	        }
	        //$(this).hide();
	    }
	);

	

	/* SWITCH CASH AND EXTERNAL TERMINAL*/
	$('#cash-tab').click(function(){
		$('.switch-cash').show();
		$(this).addClass('btn-success').removeClass('btn-default');
		$('#terminal-tab').removeClass('btn-success').addClass('btn-default');
		$('.switch-terminal').hide();
	});
	$('#terminal-tab').click(function(){
		$('.switch-terminal').show();
		$(this).addClass('btn-success').removeClass('btn-default');
		$('#cash-tab').removeClass('btn-success').addClass('btn-default');
		$('.switch-cash').hide();
	});

	/* ADJUST NUMBER BUTTON*/
	$('.product-number .minus').click(function(){
		var currentNumber = $('.product-number .item-number').text();
		$('.item-number').text(parseInt(currentNumber) - 1);
	});
	$('.product-number .plus').click(function(){
		var currentNumber = $('.product-number .item-number').text();
		$('.item-number').text(parseInt(currentNumber) + 1);
	});

	$('.item-unit .minus').click(function(){
		var currentNumber = $('.item-unit .item-number input').val();
		if(currentNumber <= 1) {
			 return ;
		}
		$('.item-number input').val(parseInt(currentNumber) - 1);
	});
	$('.item-unit .plus').click(function(){
		var currentNumber = $('.item-unit .item-number input').val();
		$('.item-number input').val(parseInt(currentNumber) + 1);
	});

	/* DRAWER AND ACTIVITY LOG*/
	$('#btn-drawer').click(function(){
		$('.drawer-wrapper').show();
		$('.activity-log').hide();
		$(this).addClass('btn-success').removeClass('btn-default');
		$('#btn-activity').removeClass('btn-success').addClass('btn-default');
	});
	$('#btn-activity').click(function(){
		$('.activity-log').show();
		$('.drawer-wrapper').hide();
		$(this).addClass('btn-success').removeClass('btn-default');
		$('#btn-drawer').removeClass('btn-success').addClass('btn-default');
	});

	//$('.add-amount-modal').modal('show');
	//$('.no-conn-modal').modal('show');

	/* CALCULATOR */

	//percentages
	var decimalVal = function(num){
		fixedNum = 2;
		return parseFloat(num).toFixed(fixedNum);
	}
	var percentageBtn = function(btn, val, resultBox){
		$(btn).click(function(e){
			e.preventDefault();
			$('.percentage-tab').addClass('btn-success').removeClass('btn-default');
			$('.dollar-tab').addClass('btn-default').removeClass('btn-success');
			$(this).addClass('btn-success').removeClass('btn-defualt');
			$(this).siblings('a').addClass('btn-default').removeClass('btn-success');
			var result = decimalVal(val);
			$(resultBox).val(result);
		});
	}
	var numberBtn = function(btn, val, resultBox){
		$(btn).click(function(e){
			
			e.preventDefault();
			$('.numeric-btn').find('a').addClass('btn-default').removeClass('btn-success');
			var result = val;
			result += $(resultBox).val().toString();
			$(resultBox).val(result);
		});
	}
	$('.dollar-tab').click(function(e){
		e.preventDefault();
		$(this).addClass('btn-success').removeClass('btn-default');
		$('.percentage-tab').addClass('btn-default').removeClass('btn-success');
	});
	$('.percentage-tab').click(function(e){
		e.preventDefault();
		$(this).addClass('btn-success').removeClass('btn-default');
		$('.dollar-tab').addClass('btn-default').removeClass('btn-success');
	});

	percentageBtn('#five-percent', 5, '#result-text');
	percentageBtn('#ten-percent', 10, '#result-text');
	percentageBtn('#twenty-percent', 20, '#result-text');
	percentageBtn('#thirty-percent', 30, '#result-text');
	percentageBtn('#fifty-percent', 50, '#result-text');
	percentageBtn('#clear-text', 0, '#result-text');

	numberBtn('#number-one',1, '#result-text');
	numberBtn('#number-two',2, '#result-text');
	numberBtn('#number-three',3, '#result-text');
	numberBtn('#number-four',4, '#result-text');
	numberBtn('#number-five',5, '#result-text');
	numberBtn('#number-six',6, '#result-text');
	numberBtn('#number-seven',7, '#result-text');
	numberBtn('#number-eight',8, '#result-text');
	numberBtn('#number-nine',9, '#result-text');
	numberBtn('#number-enter','', '#result-text');
	numberBtn('#number-dot','.', '#result-text');
	numberBtn('#number-zero',0, '#result-text');

	//numbers

	/* SIDEBAR ITEM LIST*/
	$('#edit-sidebar-item').on('show.bs.modal', function(e){
			//get data-item-id value when show modal
		var itemId = $(e.relatedTarget).data('item-id'),
			//get selector from sidebar list item
			itemList = $('li[data-item-id="' + itemId + '"]'),
			//get the title from list item
			listTitle = itemList.find('.title').text(),
			//get item number from list item
			itemUnit = itemList.find('.badge').text(),
			//get price from list item
			listPrice = itemList.find('span.price-val').text(),
			listDiscount = itemList.find('.discount-val').val();
		$(e.currentTarget).find('h5').text(listTitle);
		$(e.currentTarget).find('#product-id').val($(e.relatedTarget).data('product-id'));
		$(e.currentTarget).find('#order-id').val($(e.relatedTarget).data('order-id'));
		$(e.currentTarget).find('.item-number input').val(parseInt(itemUnit)).focus();
		$(e.currentTarget).find('input[name="item-price"]').val(decimalVal(listPrice));
		$(e.currentTarget).find('input[name="item-discount"]').val(parseInt(listDiscount));
	});


	/*
	Trigger Sidebar
	 */
	$('.trigger-sidebar').on('click',function(){
		$('.sale-container').toggleClass('sidebar-open');
		$('.sale-container').toggleClass('sidebar-collapse');
	});

	/* CURRENCY MODAL */
	// disable checkout button from submitting
	$('#btn-submit').prop('disabled', true).addClass('disabled btn-default').removeClass('btn-success');
	if($('.product-list > .row').data('customer-id')){
		$('#btn-submit').prop('disabled', false).removeClass('disabled btn-default').addClass('btn-success');
	}
	$('.currency-modal').on('show.bs.modal', function() {
		var priceDollar = $('.usd-price').val();
		var exchange 		=	parseInt($('.cart-item-container').data('currency'));
		var priceRiel 	= priceDollar * exchange;
		$('.currency-modal .price-title-dollar').text(" $ " + priceDollar);
		$('.currency-modal .price-title-riel').text( "៛ " + priceRiel);
		//check whether input fields are not empty or zero	
		if(($('#input-dollar').val() != '0' && $('#input-dollar').val() != '') ||
			($('#input-riel').val() != '0' && $('#input-riel').val() != '') ){
			var inputDollar = parseFloat($('#input-dollar').val());
			var inputRiel = parseFloat($('#input-riel').val()/exchange);
			var inputTotal = parseFloat(inputDollar + inputRiel).toFixed(2);
			var receivedTotal = parseFloat(inputTotal - parseFloat(priceDollar)).toFixed(2);
			var receivedTotalRiel = receivedTotal * exchange;
			$('#received-total').val(receivedTotal + " $ | "+ receivedTotalRiel + " រៀល");
		}
		$('#input-dollar, #input-riel, #select-customer').bind("keyup change",function(){
		    var selectedValue = $('#select-customer').val();
		    if($('#input-dollar, #input-riel').val() != ""){
		      var inputDollar = parseFloat($('#input-dollar').val());
		      var inputRiel = parseFloat($('#input-riel').val()/exchange);
		      var inputTotal = parseFloat(inputDollar + inputRiel).toFixed(2);
		      var receivedTotal = parseFloat(inputTotal - parseFloat(priceDollar)).toFixed(2);
		      var receivedTotalRiel = receivedTotal * exchange;
		      $('#received-total').val(receivedTotal + " $ | "+ receivedTotalRiel + " រៀល");
		      if(selectedValue == '' || selectedValue == null && receivedTotal < 0){
		      	$('#btn-submit').prop('disabled', true).addClass('disabled btn-default').removeClass('btn-success');
		      }
		      else{
		      	$('#btn-submit').prop('disabled', false).removeClass('disabled btn-default').addClass('btn-success');
		      }
		    }else{
		      $('#received-total').val('0');
		    }
		});

		/* FOCUS ON INPUT DOLLAR AND RIEL*/

		$("#input-riel, #input-dollar").focus(function() { 
			if($(this).val() == '0'){
				$(this).val('').end();
			}
		});
		$('#input-riel').focus(function(){
			if($('#input-dollar').val() == ""){
				$("#input-dollar").val('0');
			}
		});
		$("#input-riel, #input-dollar").blur(function() { 
			if($('#input-dollar').val() == ""){
				$("#input-dollar").val('0');
			}
		});

	});
	
	
	$('#numpadButton-btn').numpad({
		target: $('#numpadButton')
	});
	$('#usd-btn').numpad({
		target: $('#input-dollar'),
		onKeypadClose: function(){
			$('#usd-btn').trigger('change');
		}
	});
	$('#item-price-btn').numpad({
		target: $('#item-price'),
		onKeypadClose: function(){
			$('#usd-btn').trigger('change');
		}
	});
	$('#item-discount-btn').numpad({
		target: $('#item-discount'),
		onKeypadClose: function(){
			$('#usd-btn').trigger('change');
		}
	});
	$('#item-number-btn').numpad({
		target: $('#item-number'),
	});
	$('#riel-btn').numpad({
		target: $('#input-riel')
	});
	$('.currency-modal,.item-list-modal').on('hide.bs.modal', function(e){
		$('.nmpd-wrapper').hide();
	});
	$('.currency-modal').on('shown.bs.modal', function () {
    $('#input-dollar').focus();
	})
	
});
