/**
 * Webcam function
 */
 $(".preview_snapshot").hide();
 $(".cancel_preview").hide();
 Webcam.set({
   // live preview size
   width: 320,
	 height: 240,

   // device capture size
   dest_width: 640,
   dest_height: 480,

   // final cropped size
   crop_width: 480,
   crop_height: 480,

   // format and quality
   image_format: 'jpeg',
   jpeg_quality: 100,

   // flip horizontal (mirror mode)
   flip_horiz: false
 });
 function start_webcam() {
   Webcam.attach( '#my_camera' );
   //$('video').css("width", "100%");
   $(".start_webcam").hide('fast', function() {
     $(".preview_snapshot").show();
     $(".cancel_preview").show();
     $("#my_camera").show();
   });
 }
 function closeWebCam() {
   Webcam.reset();
   $(".start_webcam").show('fast', function() {
     $(".preview_snapshot").hide();
     $(".cancel_preview").hide();
     $("#my_camera").hide();
   });
 }

 function preview_snapshot() {
   Webcam.freeze();

   Webcam.snap( function(data_uri) {
     $('#results').show();
     $('#results').html('<img class="img img-thumbnail img-responsive" src='+data_uri+'>');
     $('#image_name').text(data_uri);
   } );
 }
