/**
 * Quotation
 */
 var quotation = {
 	/**
 	 * Load Product in Stock
 	 * @return {[type]} [description]
 	 */
 	listPinStock: function () {
 		$("#products-in-stock").DataTable({
 			"ajax"        : $('.qurl').data('list-products'),
 			"processing"  : true,
 			"serverSide"  : true,
 			"paging": true,
 			"autoWidth": false,
 			"columnDefs": [
 			{ "searchable": false, "targets": 4 },
 			],
 			"columns": [
	 			{data: 'sku', name: 'products.sku', orderable: false},
        {data: 'name', name: 'products.name',orderable: false},
	 			{data: 'available_amount', name: 'outlets.available_amount',orderable: false},
	 			{data: 'price', name: 'products.price',orderable: false},
	 			{data: 'action', name: 'action',orderable: false}
 			],
 			initComplete: function () {
 				this.api().columns([1,2,3]).every(function () {
 					var column = this;
 					var input = document.createElement("input");
 					$(input).appendTo($(column.footer()).empty())
 					.on('change', function () {
 						var val = $.fn.dataTable.util.escapeRegex($(this).val());
 						column.search(val ? val : '', true, false).draw();
 					});
 				});
 			}

 		});
 	},

 	/**
 	 * Add new Product in Quotaion
 	 */
 	addNewProduct: function () {
 		var q = this;
 		$(document).on('click', ".btn-add-cart", function () {
      var p = $(this);
      var data = {
        'product_id': p.data('product-id'),
        'sku': p.data('sku'),
        'invoice_id': $("#invoice-id").data('id'),
        'price': p.data('price')
      };
      $.ajax({
        url: $(".qurl").data('add-product'),
        type: "POST",
        data: data,
        success: function (data) {
          toastr.options = {
            "progressBar": false,
            "positionClass": "toast-bottom-left",
            "hideMethod": "fadeOut"
          }
          if(data.error){
            toastr.error(data.msg);
          } else {
          	q.loadProduct();
            toastr.success(data.msg);
          }
        }
      });
    });
 	},

 	/**
 	 * Edit amount product in quoation
 	 * @return {[type]} [description]
 	 */
 	editProductAmount: function () {
 		var q = this;
 		$(document).on('click', '.btn-update', function () {
      var id  = $(this).data('product-id');
      var data = {
        'product_id': id,
        'invoice_id': $("#invoice-id").data('id'),
        'qty': $('#qty-update-'+ id).val(),
        'price': $("#qty-price-"+ id).val(),
      };
      $.ajax({
        url : $('.qurl').data('update-product'),
        type: "POST",
        data: data,
        success: function (data) {
           toastr.options = {
              "progressBar": false,
              "positionClass": "toast-bottom-left",
              "hideMethod": "fadeOut"
            }
            if(data.error){
              toastr.error(data.msg);
            } else {
            	q.loadProduct();
              toastr.success(data.msg);
            }
        }
      });
    });
 	},

 	/**
 	 * Load Products in quotaion
 	 * @return {[type]} [description]
 	 */
 	loadProduct: function () {
 	 	var url = $("#invoice-id").data('url');
 	 	var q = this;
    $("#load-preorders").load(url, function(responseTxt, statusTxt, xhr) {
        if(statusTxt == "success") {
        	console.log("External content loaded successfully!");
        	if ($(".no-row").length > 0) {
	          $(".btn-confirm").attr('disabled',true);
	        } else {
	          $(".btn-confirm").attr('disabled',false);
	        }
        }   
        if(statusTxt == "error")
            console.log("Error: " + xhr.status + ": " + xhr.statusText);
    });
 	},

 	deleteProduct: function () {
 		var q = this;
 		$(document).on('click', '.btn-delete', function () {
      var answer = confirm("Do you want to delete?");
      if (answer) {
 			var p = $(this);
 			$.ajax({
 				url: $(".qurl").data('delete-product'),
 				type: "DELETE",
 				data:{ 
 					'invoice_id': $("#invoice-id").data('id'),
 					'product_id': p.data('product-id')
 				},
 				success: function (data) {
 					console.log(data);
 					toastr.options = {
              "progressBar": false,
              "positionClass": "toast-bottom-left",
              "hideMethod": "fadeOut"
            }
            if(data.error){
              toastr.error(data.msg);
            } else {
            	q.loadProduct();
              toastr.success(data.msg);
            }
 				}
 			});
    }
 		});
 	},
  addProduct: function () {
    var q = this;
    $("#formNewProduct").submit(function (e) {
      e.preventDefault();
      formUrl = $(this).attr('action');
      var data = $(this).serialize();
      $.ajax({
        url: formUrl,
        type: "POST",
        data: data,
        success : function (data) {
          toastr.options = {
              "progressBar": false,
              "positionClass": "toast-bottom-left",
              "hideMethod": "fadeOut"
            }
            if(data.error){
              toastr.error(data.msg);
            } else {
              q.loadProduct();
              $("#newProduct").modal('hide');
              $("#formNewProduct")[0].reset();
              toastr.success(data.msg);
            }
        }
      });
    });
  }
 }; 