jQuery(function($) {

		// toastr.success('Are you the 6 fingered man?');
		/*
		Update Product History Reference ID
		 */
		+(function() {
			$('.save_ref_id').on('click',function(e){
				container = $(this).parents('tr');
				ref_id = container.find('input').val();
				history_url = container.data('url');
				$.ajax({
						type: "PATCH",
						url : history_url,
						data : "ref_id="+ref_id,
						success : function(data){
								var returnData = data;
								toastr.options = {
									"progressBar": false,
									"positionClass": "toast-bottom-left",
									"hideMethod": "fadeOut"
								}
								if(returnData.error)
									toastr.error("Something Went Wrong");
								else
									toastr.success("Successfully Updated");
						}
				},"json");

				});
		})();

		/**
		 * Add Category
		 */
		+(function() {
			$('#form-add-category').on('submit',function(e){
				e.preventDefault();
				addCateUrl = $(this).attr('action');
				$.ajax({
						type: "POST",
						url : addCateUrl,
						data : { 'category_name': $('#category_name').val() },
						success : function(data){
								toastr.options = {
									"progressBar": false,
									"positionClass": "toast-bottom-left",
									"hideMethod": "fadeOut"
								}
								if(data.error == true)
									toastr.error(data.msg);
								else {
									$('#addCategory').modal('hide');
									var newOption = new Option(data.category.name, data.category.id, true, true);
									$("#product_category_id").append(newOption).trigger('change');
									toastr.success(data.msg);
								}
						}
				},"json");

				});
		})();
		/**
		 * Transfer Products To Stock
		 */
		+(function(){
			$("#checkAll").click(function(){
		    $('input:checkbox').not(this).prop('checked', this.checked);
			});
			$(".transfer_to_stock_btn").on('click',function(e){
				e.preventDefault();
				stockId = $('.stock_id').val();
				discount = $('.discount').val();
				batchTransferToStockUrl = $('.transfer_to_stock_form').data('url');
				console.log($('.product_id:checked').serialize());
				$.ajax({
						type: "POST",
						url : batchTransferToStockUrl,
						data : "stock_id="+stockId+"&"+$('.product_id:checked').serialize()+"&discount="+discount,
						success : function(data){
							var returnData =  data;
							toastr.options = {
								"progressBar": false,
								"positionClass": "toast-bottom-left",
								"hideMethod": "fadeOut"
							}
							console.log(returnData);
							if(returnData.error == false){
								$.each(returnData.products, function(k, v) {
									toastr.success(v+" Successfully transferred");
									$(":checkbox[value="+k+"]").closest('tr').find('td:nth-child(5)').html(0);
									$(":checkbox[value="+k+"]").closest('tr').find('td:nth-child(8)').html(discount+"%");
								});
							}
							else {
								toastr.error("Transferring not success");
							}
						}
				},"json");
			});
		})();

    +(function() {
      $('#form-add-unit').on('submit', function(e) {
        e.preventDefault();
        $.ajax({
          type: "POST",
          url: $(this).attr('action'),
          data: {'unit_name': $('#unit_name').val()},
          success: function (data) {
            toastr.options = {
              "progressBar": false,
              "positionClass": "toast-bottom-left",
              "hideMethod": "fadeOut"
            }
            if (data.error == true) {
              toastr.error(data.msg);
            } else{
              toastr.success(data.msg);
              $("#unit-modal").modal('hide');
              var newOption = new Option(data.unit, data.id, true, true);
              $("#unit_id").append(newOption).trigger('change');
            }
          }
        });
      });

      $('#form-add-supplier').on('submit', function(e) {
        e.preventDefault();
        $.ajax({
          type: "POST",
          url: $(this).attr('action'),
          data: {
            'company_name': $('#company_name').val(),
            'tel':  $("#tel").val()
          },
          success: function (data) {
            toastr.options = {
              "progressBar": false,
              "positionClass": "toast-bottom-left",
              "hideMethod": "fadeOut"
            }
            if (data.error == true) {
              toastr.error(data.msg);
            } else{
              toastr.success(data.msg);
              $("#supplier-modal").modal('hide');
              var newOption = new Option(data.company_name, data.id, true, true);
              $("#supplier_id").append(newOption).trigger('change');
            }
          }
        });
      });

      $('#form-add-item-location').on('submit', function(e) {
        e.preventDefault();
        $.ajax({
          type: "POST",
          url: $(this).attr('action'),
          data: {'item_location_name': $('#item_location_name').val()},
          success: function (data) {
            toastr.options = {
              "progressBar": false,
              "positionClass": "toast-bottom-left",
              "hideMethod": "fadeOut"
            }
            if (data.error == true) {
              toastr.error(data.msg);
            } else{
              toastr.success(data.msg);
              $("#item-location-modal").modal('hide');
              var newOption = new Option(data.item_location_name, data.id, true, true);
              $("#item_location_id").append(newOption).trigger('change');
            }
          }
        });
      });
      // Add brand quick form
      $('#form-add-brand').on('submit', function(e) {
        e.preventDefault();
        $.ajax({
          type: "POST",
          url: $(this).attr('action'),
          data: {'brand_name': $('#brand_name').val()},
          success: function (data) {
            toastr.options = {
              "progressBar": false,
              "positionClass": "toast-bottom-left",
              "hideMethod": "fadeOut"
            }
            if (data.error == true) {
              toastr.error(data.msg);
            } else{
              toastr.success(data.msg);
              $("#brand-modal").modal('hide');
              var newOption = new Option(data.brand, data.id, true, true);
              $("#brand_id").append(newOption).trigger('change');
            }
          }
        });
      });

    })();
});
