/**
 * Quotation object
 * @type object
 * @author Sok Kimsoeurn <sokkimsoeurn@gmail.com>
 */
var quotation = {
  /**
   * Customer ID
   * @type integer
   */
  customerID: $('#customer_id').data('customer-id'),
  /**
   * Customer Quotation ID
   * @type integer
   */
  customerQuotID: $("#customer_quot_id").data('customer-quot-id'),
  /**
   * Post Add Item into Quotation
   * @param integer id
   */
  addItem: function(id) {
    var p = this;
    var data = {
      'product_id': id,
      'amount': $('#qty'+id).val(),
      'customer_id': p.customerID
    };
    $.ajax({
      type: "POST",
      url: $('#addItem').data('add-item'),
      data: data,
      success: function(data) {
        toastr.options = {
          "progressBar": false,
          "positionClass": "toast-bottom-left",
          "hideMethod": "fadeOut"
        }
        if(data.error == true) {
          toastr.error(data.msg);
          if(data.reload == true) {
            location.reload();
          }
        } else {
          p.listItem();
          toastr.success(data.msg);
        }
      }
    });
  },
  /**
   * Get Products Orders
   */
  listItem: function() {
    var p = this;
    var tr = "<tr><td colspan='6' class='text-center'>No Order Item</td></tr>";
    $.ajax({
      type: "GET",
      url: $('#getItem').data('get-item'),
      data: {'customer_id': p.customerID,
             'customer_quot_id': p.customerQuotID },
      success: function(data) {
        if (data.error == true) {
          $('#btn-cancel').prop('disabled', true);
          $('#btn-confirm').prop('disabled', true);
          $('#data').html(tr);
        } else {
          $('#btn-cancel').prop('disabled', false);
          $('#btn-confirm').prop('disabled', false);
          $("#data").html(data);
          var total = $('#total').data('total');
          $("#usd-total-price").text(" $ " + parseFloat(total).toFixed(2));
        }
      }
    });
  },
  /**
   * Edit Amount of Products
   * @param order id
   */
  editItem: function(id) {
    var p = this;
    var data = {
                'quotation_id': id,
                'amount': $("#qtyupdate"+id).val(),
                'product_id': $("#qtyupdate"+id).data('product-id'),
                'customer_quot_id': p.customerQuotID
               };
    $.ajax({
      type: "PATCH",
      url: $('#editItem').data('edit-item'),
      data: data,
      success: function(data) {
        console.log(data);
        toastr.options = {
          "progressBar": false,
          "positionClass": "toast-bottom-left",
          "hideMethod": "fadeOut"
        }
        if(data.error == true) {
          toastr.error(data.msg);
          if(data.reload == true) {
            p.listItem();
          }
        } else {
          p.listItem();
          toastr.success(data.msg);
        }
      }
    });
  },
  /**
  * Delete product by id
  */
 deleteItem: function(id) {
   var p = this;
   $.ajax({
     type: "DELETE",
     url: $('#deleteItem').data('delete-item'),
     data: {"quotation_id": id, "customer_quot_id": p.customerQuotID},
     success: function(data) {
       console.log(data);
       toastr.options = {
         "progressBar": false,
         "positionClass": "toast-bottom-left",
         "hideMethod": "fadeOut"
       }
       if(data.error == true) {
         toastr.error(data.msg);
       } else {
         p.listItem();
         toastr.success(data.msg);
       }
     }
   });
 },
 /**
  * Cancel Orders
  */
 cancelOrder: function() {
   var p = this;
   $('#alert-yes').on('click', function() {
     $.ajax({
       type: "DELETE",
       url: $('#deleteAllItem').data('delete-all-item'),
       data: { "customer_quot_id": p.customerQuotID },
       success: function(data) {
         toastr.options = {
           "progressBar": false,
           "positionClass": "toast-bottom-left",
           "hideMethod": "fadeOut"
         }
         if(data.error == true) {
           toastr.error(data.msg);
         } else {
           p.listItem();
           toastr.success(data.msg);
         }
       }
     });
     $('#modal-2').modal('hide');
   });
 },
 /**
  * Submit Quotation
  * @return void
  */
 submitQuotation: function() {
   $('#btn-confirm').on('click', function() {
    location.reload();
   });
 }
};
