/**
 * Purchase Order
 * @type Object
 */
var purchaseOrder = {
  url: "/suppliers/purchase/order",
  supplierID : $('#supplier_id').data('supplier-id'),
  /**
   * Add Product into Orders
   * @param  int id of button elements
   */
  addItem: function(id) {
    var p  = this;
    var data = {
      'product_id': id,
      'amount': $('#qty'+id).val(),
      'price': $('#qty'+id).data('price'),
      'sku': $('#qty'+id).data('sku'),
      'supplier_id': p.supplierID
    };
    $.ajax({
      type: "POST",
      url: "<?= route('postOrderProduct') ?>",
      data: data,
      success: function(data) {
        toastr.options = {
          "progressBar": false,
          "positionClass": "toast-bottom-left",
          "hideMethod": "fadeOut"
        }
        if(data.error == true) {
          toastr.error(data.msg);
        } else {
          p.listItem();
          toastr.success(data.msg);
        }
      }
    });
  },
  /**
   * Get Products Orders
   */
  listItem: function() {
    var p = this;
    var tr = "<tr><td colspan='6' class='text-center'>No Order Item</td></tr>";
    $.ajax({
      type: "GET",
      url: p.url,
      data: {"supplier_id": p.supplierID},
      success: function(data) {
        if (data.error == true) {
          $('#btn-cancel').prop('disabled', true);
          $('#btn-confirm').prop('disabled', true);
          $('#data').html(tr);
        } else {
          $('#btn-cancel').prop('disabled', false);
          $('#btn-confirm').prop('disabled', false);
          $("#data").html(data);
          var total = $('#total').data('total');
          $("#usd-total-price").text(" $ " + parseFloat(total).toFixed(2));
        }
      }
    });
  },
  /**
   * Edit Amount of Products
   * @param order id
   */
  editItem: function(id) {
    var data = {'order_id': id, 'amount': $("#qtyupdate"+id).val() };
    var p = this;
    $.ajax({
      type: "PATCH",
      url: p.url,
      data: data,
      success: function(data) {
        toastr.options = {
          "progressBar": false,
          "positionClass": "toast-bottom-left",
          "hideMethod": "fadeOut"
        }
        if(data.error == true) {
          toastr.error(data.msg);
        } else {
          p.listItem();
          toastr.success(data.msg);
        }
      }
    });
  },
  /**
   * Delete product by id
   */
  deleteItem: function(id) {
    var p = this;
    $.ajax({
      type: "DELETE",
      url: p.url,
      data: {"order_id": id},
      success: function(data) {
        toastr.options = {
          "progressBar": false,
          "positionClass": "toast-bottom-left",
          "hideMethod": "fadeOut"
        }
        if(data.error == true) {
          toastr.error(data.msg);
        } else {
          p.listItem();
          toastr.success(data.msg);
        }
      }
    });
  },
  /**
   * Cancel Orders
   */
  cancelOrder: function() {
    var p = this;
    $('#alert-yes').on('click', function() {
      var url = "/suppliers/purchase/order/all";
      $.ajax({
        type: "DELETE",
        url: url,
        data: {'supplier_id': p.supplierID},
        success: function(data) {
          toastr.options = {
            "progressBar": false,
            "positionClass": "toast-bottom-left",
            "hideMethod": "fadeOut"
          }
          if(data.error == true) {
            toastr.error(data.msg);
          } else {
            p.listItem();
            toastr.success(data.msg);
          }
        }
      });
      $('#modal-2').modal('hide');
    });
  }
};
// End Object
