jQuery(function($) {

    // toastr.success('Are you the 6 fingered man?');
    /*
    Update Product History Reference ID
     */
    +(function() {
        $('.save_ref_id').on('click', function(e) {
            e.preventDefault();
            container = $(this).parents('tr');
            ref_id = container.find('input').val();
            history_url = container.data('url');
            $.ajax({
                type: "PATCH",
                url: history_url,
                data: "ref_id=" + ref_id,
                success: function(data) {
                    var returnData = data;
                    toastr.options = {
                        "progressBar": false,
                        "positionClass": "toast-bottom-left",
                        "hideMethod": "fadeOut"
                    }
                    if (returnData.error)
                        toastr.error("Something Went Wrong");
                    else
                        toastr.success("Successfully Updated");
                }
            }, "json");

        });
    })();

    /**
     * Add Category
     */
    +
    (function() {
        $('.add_quick_add_category_input').on('click', function(e) {
            e.preventDefault();
            addCateUrl = $(this).data('url');
            $.ajax({
                type: "POST",
                url: addCateUrl,
                data: "name=" + $('.quick_add_category_input').val(),
                success: function(data) {
                    var returnData = data //jQuery.parseJSON( data );
                    console.log(returnData);
                    toastr.options = {
                        "progressBar": false,
                        "positionClass": "toast-bottom-left",
                        "hideMethod": "fadeOut"
                    }
                    if (returnData.error == true)
                        toastr.error("Something Went Wrong");
                    else {
                        $('#myCategory').modal('hide');
                        var newOption = new Option(returnData.category.name, returnData.category.id, true, true);
                        $(".categories").append(newOption).trigger('change');
                        toastr.success("Successfully Updated");
                    }
                }
            }, "json");

        });
    })();
    /**
     * Transfer Products To Stock
     */
    +
    (function() {
        $("#checkAll").click(function() {
            $('input:checkbox').not(this).prop('checked', this.checked);
        });
        $(".transfer_to_stock_btn").on('click', function(e) {
            e.preventDefault();
            stockId = $('.stock_id').val();
            discount = $('.discount').val();
            batchTransferToStockUrl = $('.transfer_to_stock_form').data('url');
            console.log($('.product_id:checked').serialize());
            $.ajax({
                type: "POST",
                url: batchTransferToStockUrl,
                data: "stock_id=" + stockId + "&" + $('.product_id:checked').serialize() + "&discount=" + discount,
                success: function(data) {
                    var returnData = data;
                    toastr.options = {
                        "progressBar": false,
                        "positionClass": "toast-bottom-left",
                        "hideMethod": "fadeOut"
                    }
                    console.log(returnData);
                    if (returnData.error == false) {
                        $.each(returnData.products, function(k, v) {
                            toastr.success(v + " Successfully transferred");
                            $(":checkbox[value=" + k + "]").closest('tr').find('td:nth-child(5)').html(0);
                            $(":checkbox[value=" + k + "]").closest('tr').find('td:nth-child(8)').html(discount + "%");
                        });
                    } else {
                        toastr.error("Transferring not success");
                    }
                }
            }, "json");
        });
    })();

    
});