$('.btn-show-modal').on('click', function (e) {
    e.preventDefault();
    var me = $(this);
    var url = me.attr('href');
    var title = me.data("title");
    $.ajax({
        url: url,
        dataType: "html",
        success: function (data) {
            $("#form-body").html(data);
            $("#modal-title").html(title);
            $('#payment_date').datepicker({
                format: "dd/mm/yyyy",
                todayHighlight: true,
                autoclose: true
            }).datepicker("setDate", "0");
            $('#modal-mortgage-payment').modal({backdrop: 'static', keyboard: false}).show();
            $("#modal-mortgage-payment").on('shown.bs.modal', function () {
                $("#receipt_id").focus();
            });
        }
    });
});
$(document).on('click', '.btn-save-payment', function (e) {
    e.preventDefault();
    var form = $("#form-body form");
    form.find('.text-danger').remove();
    form.find('.form-group').removeClass('has-error');
    var url  = form.attr('action');
    var data = form.serialize();
    $.ajax({
        type:'POST',
        url: url,
        data: data,
        success:function(data){
            data = jQuery.parseJSON(data);
            if (data.error == false) {
                $('#modal-mortgage-payment').modal('hide');
                swal({
                    title: "ជូនដំណឹង",
                    text: data.message,
                    type: "success",
                    allowEscapeKey: true,
                    confirmButtonText: "យលព្រម",
                    animation: "slide-from-top",
                }, function () {
                    location.reload();
                });
            } else {
                swal({
                    title: "ជូនដំណឹង",
                    text: data.message,
                    type: "error",
                    allowEscapeKey: true,
                    confirmButtonText: "យលព្រម",
                    animation: "slide-from-top",
                });
                console.log(data);
            }
        },
        error: function(data){
            var json = data.responseJSON;
            var errors = json.errors;
            if ($.isEmptyObject(errors) == false) {
                $.each(errors, function (key, val) {
                    $("#" + key)
                        .closest('.form-group')
                        .addClass('has-error')
                        .append('<small class="text-danger">' + val +'</samll>');
                });
            }
        }
    });

});
$(".btn-no-return").on("click", function (e) {
    e.preventDefault();
    var me = $(this);
    var url = me.attr('href');
    swal({
            title: "Are you sure?",
            type: "warning",
            showCancelButton: true,
            confirmButtonText: "Yes",
            cancelButtonText: "No",
            closeOnConfirm: false
        },
        function(){
            $.ajax({
                type:'POST',
                url: url,
                success:function(data){
                    data = jQuery.parseJSON(data);
                    if (data.error == false) {
                        swal({
                            title: "ជូនដំណឹង",
                            text: data.message,
                            type: "success",
                            animation: "slide-from-top",
                        }, function () {
                            location.reload();
                        });
                    } else {
                        swal({
                            title: "ជូនដំណឹង",
                            text: data.message,
                            type: "error",
                            allowEscapeKey: true,
                            confirmButtonText: "យលព្រម",
                            animation: "slide-from-top",
                        });
                        console.log(data);
                    }
                }
            });
        });
});
$('.btn-payment-history').on('click', function (e) {
    e.preventDefault();
    var url = $(this).attr('href');
    $.ajax({
        url: url,
        dataType: "html",
        success: function (data) {
            data = jQuery.parseJSON(data);
            $("#payment-history-body").html(data);
        }
    });
    $('#payment-history').modal({backdrop: 'static', keyboard: false}).show();
});