
$('.btn-show-payment-modal').on('click', function (e) {
    e.preventDefault();
    var url = $(this).attr('href');
    $.ajax({
        url: url,
        dataType: "html",
        success: function (data) {
            $("#form-payment-body").html(data);
            $('#payment_date').datepicker({
                format: "dd/mm/yyyy",
                todayHighlight: true,
                autoclose: true
            }).datepicker("setDate", "0");
            $('#monthly-payment-modal').modal({backdrop: 'static', keyboard: false}).show();
            $("#monthly-payment-modal").on('shown.bs.modal', function () {
                $("#receipt_id").focus();
            });
        }
    });
});
$(document).on('click', '.btn-save-payment', function (e) {
    e.preventDefault();
    var form = $("#form-payment-body form");
    form.find('.text-danger').remove();
    form.find('.form-group').removeClass('has-error');
    var url = form.attr('action');
    var data = form.serialize();
    $.ajax({
        type: 'POST',
        url: url,
        data: data,
        success: function (data) {
            
            console.log(data);
            
            if (data.error == false) {
                $('#monthly-payment-modal').modal('hide');
                swal({
                    title: "ជូនដំណឹង",
                    text: data.message,
                    type: "success",
                    allowEscapeKey: true,
                    confirmButtonText: "យលព្រម",
                    animation: "slide-from-top",
                }, function () {
                    location.reload();
                });
            } else {
                swal({
                    title: "ជូនដំណឹង",
                    text: data.message,
                    type: "error",
                    allowEscapeKey: true,
                    confirmButtonText: "យលព្រម",
                    animation: "slide-from-top",
                });
            }
        },
        error: function (data) {
            var json = data.responseJSON;
            var errors = json.errors;
            if ($.isEmptyObject(errors) == false) {
                $.each(errors, function (key, val) {
                    $("#" + key)
                        .closest('.form-group')
                        .addClass('has-error')
                        .append('<small class="text-danger">' + val + '</samll>');
                });
            }
        }
    });

});
$('.btn-payment-history').on('click', function (e) {
    e.preventDefault();
    var url = $(this).attr('href');
    $.ajax({
        url: url,
        dataType: "html",
        success: function (data) {
            
            $("#payment-history-body").html(data);
        }
    });
    $('#payment-history').modal({backdrop: 'static', keyboard: false}).show();
});
$('.btn-paid-all').on('click', function (e) {
    e.preventDefault();
    var url = $(this).attr('href');
    $.ajax({
        url: url,
        dataType: "html",
        success: function (data) {
            
            $("#form-paid-body").html(data);
            $('#payment_date').datepicker({
                format: "dd/mm/yyyy",
                todayHighlight: true,
                autoclose: true
            }).datepicker("setDate", "0");
            $('#paid-all-modal').modal({backdrop: 'static', keyboard: false}).show();
            $("#paid-all-modal").on('shown.bs.modal', function () {
                $("#receipt_id").focus();
            });
        }
    });
});
$(document).on('click', '.btn-save-payment-all', function (e) {
    e.preventDefault();
    var form = $("#form-paid-body form");
    form.find('.text-danger').remove();
    form.find('.form-group').removeClass('has-error');
    var url = form.attr('action');
    var data = form.serialize();
    $.ajax({
        type: 'POST',
        url: url,
        data: data,
        success: function (data) {
            
            if (data.error == false) {
                $('#paid-all-modal').modal('hide');
                swal({
                    title: "ជូនដំណឹង",
                    text: data.message,
                    type: "success",
                    allowEscapeKey: true,
                    confirmButtonText: "យលព្រម",
                    animation: "slide-from-top",
                }, function () {
                    location.reload();
                });
            } else {
                swal({
                    title: "ជូនដំណឹង",
                    text: data.message,
                    type: "error",
                    allowEscapeKey: true,
                    confirmButtonText: "យលព្រម",
                    animation: "slide-from-top",
                });
                console.log(data);
            }
        },
        error: function (data) {
            var json = data.responseJSON;
            var errors = json.errors;
            if ($.isEmptyObject(errors) == false) {
                $.each(errors, function (key, val) {
                    $("#" + key)
                        .closest('.form-group')
                        .addClass('has-error')
                        .append('<small class="text-danger">' + val + '</samll>');
                });
            }
        }
    });
});