/**
 * Buy Product 
 */
 var bp = {
	/**
	 * Load Product
	 * @return mix
	 */
	 getTable : function () {
	 	var p = this;
	 	var invoice = $("#invoice");
	 	$.ajax({
	 		type: "GET",
	 		url: invoice.data('get-table-url'),
	 		data: { 'invoiceId': invoice.data('invoice-id')},
	 		success: function (data) {
	 			$("#buy-products").html(data);
	 			p.editProduct();
	 			p.deleteProduct();
	 		}
	 	});
	 },
	 addProduct: function () {
	 	var p = this;
	 	$("#form-product").submit(function (e) {
	 		e.preventDefault();
	 		$.ajax({
	 			url: $("#form-product").attr('action'),
	 			type: 'POST',
	 			data: $("#form-product").serialize(),
	 			success: function (data) {
	 				toastr.options = {
	 					"progressBar": false,
	 					"positionClass": "toast-bottom-left",
	 					"hideMethod": "fadeOut"
	 				}
	 				if(data.error){
	 					toastr.error(data.msg);
	 				} else {
	 					console.log(data);
	 					p.getTable();
	 					$("#myModal").modal('hide');
	 					$("#form-product")[0].reset();
	 					toastr.success(data.msg);
	 				}
	 			}
	 		});
	 	});
	 },
	 editProduct: function () {
	 	var p = this;
	 	$(".btn-edit").on('click', function () {
	 		var product = $(this);
	 		var id = product.data('buy-product-id');
	 		var data = {
		 				'productId' : id,
		 				'invoiceId': product.data('invoice-id'),
		 				'qty': $('#qty-update-' + id).val()
	 				};
	 		$.ajax({
	 			type: "POST",
	 			url: $("#invoice").data('edit-url'),
	 			data: data,
	 			success: function (data) {
	 				toastr.options = {
	 					"progressBar": false,
	 					"positionClass": "toast-bottom-left",
	 					"hideMethod": "fadeOut"
	 				}
	 				console.log(data);
	 				if(data.error){
	 					toastr.error(data.msg);
	 				} else {
	 					p.getTable();
	 					toastr.success(data.msg);
	 				}
	 			}
	 		});
	 	});
	 },
	 deleteProduct: function () {
	 	var p = this;
	 	$(".btn-delete").on('click', function  () {
	 		var product = $(this);
	 		$.ajax({
	 			type: "DELETE",
	 			url: $("#invoice").data('delete-url'),
	 			data: {
	 				'productId' : product.data('buy-product-id'),
		 			'invoiceId': product.data('invoice-id'),
	 			},
	 			success: function (data) {
	 				toastr.options = {
	 					"progressBar": false,
	 					"positionClass": "toast-bottom-left",
	 					"hideMethod": "fadeOut"
	 				}
	 				if(data.error){
	 					toastr.error(data.msg);
	 				} else {
	 					p.getTable();
	 					toastr.success(data.msg);
	 				}
	 			}
	 		});
	 	});
	 },
	 selectProduct: function () {
	 	var p = this;
	 	$(".form-select-p").submit(function (e) {
      e.preventDefault();
      var form = $(this);
      var id = $(this).data('p-id');
      $.ajax({
      	url: $(".form-select-p").attr('action'),
      	type: "POST",
      	data: {
      		"qty": $("#qty-" + id).val(), 
      		"price": $("#price-in-" + id).val(),
      		'productId': id,
      		"sku": form.data('sku')
      	 },
      	success: function (data) {
      		toastr.options = {
	 					"progressBar": false,
	 					"positionClass": "toast-bottom-left",
	 					"hideMethod": "fadeOut"
	 				}
	 				console.log(data);
	 				if(data.error){
	 					toastr.error(data.msg);
	 				} else {
	 					p.getTable();
	 					$("#selectProduct-" + id).modal('hide');
	 					$(".form-select-p")[0].reset();
	 					toastr.success(data.msg);
	 				}
      	}
      });
    });
	 }
	} 