@extends('layouts.production')
@section('content')
  <section class="content-header">
    <h1>
      Users
      <small>List All Users</small>
    </h1>
    <ol class="breadcrumb">
      <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
      <li class="active">Users</li>
    </ol>
  </section>

  <!-- Main content -->
  <section class="content">
    <div class="box">
      <table class="table table-bordered">
        <thead>
          <tr>
            <th>#</th>
            <th>Username</th>
            <th>Full Name</th>
            <th>Email</th>
            <td>Actions</td>
          </tr>
        </thead>
        <tbody>
          <?php $i = 1; ?>
          @foreach($users as $user)
            <tr>
              <td>{{ $i }}</td>
              <td>{{$user->first_name}}</td>
              <td>{{$user->username}}</td>
              <td>
                <a href="{{ Route("user.edit",$user->id)}}" class="btn btn-xs btn-info">Edit</a>
                <a href="#" class="btn btn-xs btn-danger">Delete</a>

              </td>
            </tr>
          <?php $i++; ?>
          @endforeach
        </tbody>
      </table>
    </div>
  </section>
@endsection
