@extends('layouts.production')
@section('addCss')
    <style media="screen">
        #example2_filter input[type=search] {
            width: 200px;
        }
    </style>
@endsection
@section('content')
    <section class="content-header">
        <h1>
            {{ Trans("users.users")}}
            <small>{{ Trans("dashboard.others.show_all")}}</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="{{ route('user.index') }}"><i class="fa fa-users"></i>{{ trans("users.users") }}</a></li>
            <li class="active">{{ trans("dashboard.others.show_all") }}</li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        @include('layouts.includes.message')
        <div class="box box-body">
            <table class="table table-bordered table-striped" id="example1">
                <thead>
                <tr>
                    <th>{{ trans("dashboard.id") }}</th>
                    <th>{{Trans("users.fullname")}}</th>
                    <th>{{Trans("users.users")}}</th>
                    <th>{{Trans("users.roles")}}</th>
                    <th>{{Trans("users.status")}}</th>
                    @if(UserRole::has('edit_user') || UserRole::has('delete_user'))
                        <th>{{Trans("dashboard.crud.actions")}}</th>
                    @endif
                </tr>
                </thead>
                <tbody>
                @foreach($users as $user)
                        <tr>
                            <td>{{ $user->id }}</td>
                            <td>{{ $user->first_name }} {{ $user->last_name }}</td>
                            <td>{{ $user->username }}</td>
                            <td>{{ getField("Role","id",$user->role_id,"role_name") }}</td>
                            <?php
                            $status = "label-info";
                            if ($user->status == "inactive") $status = "label-danger";
                            if ($user->status == "suspended") $status = "label-warning";

                            ?>
                            <td><span class="label {{$status}}">{{ ucfirst($user->status) }}</span></td>
                            @if(UserRole::has('edit_user') || UserRole::has('delete_user'))
                                <td>
                                    @if(UserRole::has("edit_user"))
                                        <a href="{{ Route("user.edit",$user->id) }}" class="btn btn-xs btn-info"><i class="fa fa-edit"></i> {{Trans("dashboard.crud.edit")}}</a>
                                    @endif
                                    @if(UserRole::has("delete_user"))
                                        <a href="#" class="btn btn-xs btn-danger" data-toggle="modal" data-target="#myModal{{$user->id}}"><i class="fa fa-trash"></i> {{Trans("dashboard.crud.remove")}}</a>
                                        @include('layouts.includes.modals.danger', ['model' => $user,'toRoute'=>'user','attribute'=>'first_name'])
                                    @endif
                                </td>
                            @endif
                        </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </section>
@endsection
@section('addJs')
    <script>
        $(function () {
            $("#example1").DataTable();
            $('#example2').DataTable({
                "paging": true,
                "lengthChange": true,
                "searching": true,
                "ordering": false,
                "info": true,
                "autoWidth": false
            });
        });
    </script>
@endsection
