<div class="row">
  <div class="col-md-9">
    <div class="box">
      <div class="box-header with-border">
        <h3 class="box-title">{{ trans('customers.form') }} {{ trans('users.users') }}</h3>
      </div>
      <div class="box-body">
        <div class="row">
          <div class="col-md-4 form-group {{ ($errors->first('first_name')) ? "has-error" : ""}}">
            {{ Form::label('first_name', Trans("users.first_name")) }}
            {{ Form::text('first_name',null, ['class' => 'form-control', 'placeholder' => Trans("users.first_name"),"required"=>"required"]) }}
            @if($errors->first('first_name'))
              <span class="help-block">{{$errors->first('first_name')}}</span>
            @endif
          </div>
          <div class="col-md-4 form-group {{ ($errors->first('last_name')) ? "has-error" : ""}}">
            {{ Form::label('last_name', Trans("users.last_name")) }}
            {{ Form::text('last_name',null, ['class' => 'form-control', 'placeholder' => Trans("users.last_name"),"required"=>"required"]) }}
            @if($errors->first('last_name'))
              <span class="help-block">{{$errors->first('last_name')}}</span>
            @endif
          </div>
          <div class="col-md-4 form-group {{ ($errors->first('username')) ? "has-error" : ""}}">
            {{ Form::label('username',Trans("users.username")) }}
            {{ Form::text('username',null, ['class' => 'form-control', 'placeholder' => Trans("users.username"),"required"=>"required"]) }}
            @if($errors->first('username'))
              <span class="help-block">{{$errors->first('username')}}</span>
            @endif
          </div>
        </div>
        <div class="row">
          <div class="col-md-4 form-group {{ ($errors->first('email')) ? "has-error" : ""}}">
            {{ Form::label('email',Trans("users.email")) }}
            {{ Form::email('email', null, ['class' => 'form-control', 'placeholder' => Trans("users.email")]) }}
            @if($errors->first('email'))
              <span class="help-block">{{$errors->first('email')}}</span>
            @endif
          </div>
          <div class="col-md-4 form-group {{ ($errors->first('password')) ? "has-error" : ""}}">
            {{ Form::label('password',Trans("users.password")) }}
            {{ Form::password('password', ['class' => 'form-control', 'placeholder' => Trans("users.password"),"required"=>"required"]) }}
            @if($errors->first('password'))
              <span class="help-block">{{$errors->first('password')}}</span>
            @endif
          </div>
          <div class="col-md-4 form-group">
            {{ Form::label('sex',Trans("users.sex")) }}
            <?php
              if(App::getLocale() == "kh") {
                $sex = [
                  'male' => 'ប្រុស',
                  'female' => 'ស្រី',
                  "Other" => 'ផ្សេងៗ'
                ];
              }
              else {
                $sex = [
                  'male' => 'Male',
                  'female' => 'Female',
                  "other" => 'Other'
                ];
              }
            ?>
            <?php
            $selected = isset($user) ? $user->sex : "";
             ?>
            {{ Form::select('sex',$sex, $selected, ['class' => 'form-control select2']) }}
          </div>
        </div>
        <div class="row">
          <div class="col-md-4 form-group">
            {{ Form::label('date_of_birth',Trans("users.dob")) }}
            <div class="input-group date" data-provide="datepicker">
              {{ Form::text('date_of_birth', null, [
                'class' => "form-control",
                'placeholder' => Trans("users.dob")
              ]) }}
              <div class="input-group-addon">
                  <i class="fa fa-calendar"></i>
              </div>
            </div>
          </div>
          <div class="col-md-4 form-group {{ ($errors->first('tel')) ? "has-error" : ""}}">
            {{ Form::label('tel',Trans("users.tel")) }}
            {{ Form::text('tel',null, ['class' => 'form-control', 'placeholder' => Trans("users.tel")]) }}
            @if($errors->first('tel'))
              <span class="help-block">{{$errors->first('tel')}}</span>
            @endif
          </div>
          <div class="col-md-4 form-group">
            {{ Form::label('ip', Trans("users.allow_ip")) }}
            {{ Form::text('ip',null, ['class' => 'form-control', 'placeholder' => Trans("users.allow_ip")]) }}
          </div>
        </div>
        <div class="row">
          <div class="col-md-4 form-group">
            <?php $checked = (isset($user->branch_id) ? $user->branch_id : 0) ?>
            {{ Form::label('Branch',Trans("users.branch")) }}
            {{ Form::select('branch_id',$branches, $checked, ['class' => 'select2 form-control']) }}
          </div>
          <div class="col-md-4 form-group">
            <?php $checked = (isset($user->stock_id) ? $user->stock_id : 0) ?>
            {{ Form::label('stock_id',Trans('stock.stock')) }}
            {{ Form::select('stock_id',$stocks,$checked,['class' => 'select2 form-control']) }}
          </div>
          <div class="col-md-4 form-group">
            <?php $checked = (isset($user->position_id) ? $user->position_id : 0) ?>
            {{ Form::label('position',Trans("users.position")) }}
            {{ Form::select('position_id',$positions, $checked, ['class' => 'select2 form-control']) }}
          </div>
        </div>
        <div class="row">
          <div class="col-md-4 form-group">
            <?php $checked = (isset($user->role_id) ? $user->role_id : 0) ?>
            {{ Form::label('Roles',Trans("users.roles")) }}
            {{ Form::select('role_id',$roles,$checked, ['class' => 'select2 form-control']) }}
          </div>
          <div class="col-md-4 form-group">
            <?php
            $selected = isset($user) ? $user->status : "";
             ?>
            {{ Form::label('Status',Trans("status")) }}
            {{ Form::select('status', [
              'active' => 'Active',
              'suspended' => 'Suspended',
              "inactive" => 'Inactive'
            ], $selected, ['class' => 'form-control']) }}
          </div>
          <div class="col-md-4 form-group">
            {{ Form::label('id_number', Trans("users.id_number")) }}
            {{ Form::number('id_number', null, [
              'class' => "form-control",
              'placeholder' => Trans("users.id_number")
            ]) }}
          </div>
        </div>
        <div class="row">
          <div class="col-md-8 form-group">
            {{ Form::label('address',Trans("users.address")) }}
            {{ Form::textarea('address', null,
              [
                'class' => "form-control",
                'placeholder' => "Address",
                'rows' => "3"
              ]
            )}}
          </div>
          <div class="col-md-4 form-group">
            <div class="pull-right">
              <button type="submit" name="submit" class="btn btn-primary">
                @if(isset($user->id))
                  {{ Trans('dashboard.crud.update') }}
                @else
                  {{ Trans('dashboard.crud.add') }}
                @endif
              </button>
              <button type="reset" name="button" class="btn btn-default">{{ Trans('dashboard.crud.reset') }}</button>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="col-md-3">
    <div class="box">
      <div class="box-header with-border">
        <h3 class="box-title">{{ trans('customers.photo') }}</h3>
      </div>
      <div class="box-body">
        @if (isset($user->id))
            <img src="{{$user->photo}}" alt="{{ $user->username }}" class="img img-thumbnail img-responsive">
            <br><br>
        @endif
        <div class="form-group">
          {{ Form::label('photo', Trans('customers.photo')) }}
          {{ Form::file('photo', [
            'class' => "form-control",
          ]) }}
        </div>
        <div class="row">
          <div class="col-md-12">
            <div class="form-group">
              <div id="my_camera"></div>
            </div>
          </div>
          <div class="col-md-12">
            <div class="form-group">
              <div id="results" class="preview-area"></div>
            </div>
          </div>
        </div>
        <textarea id="image_name" name="image_name" style="display:none;"></textarea>
        <div class="form-group">
          <button type="button" onClick="preview_snapshot()" class="preview_snapshot btn btn-success"><i class="fa fa-play-circle-o"></i> {{Trans("users.take_snapshot")}}</button>
          <button type="button" onClick="start_webcam()" class="start_webcam btn btn-default"><i class="fa fa-camera"></i> {{Trans("users.start_webcam")}}</button>
          <button type="button" onClick="closeWebCam()" class="cancel_preview btn btn-danger"><i class="fa fa-stop"></i> Stop</button>
        </div>
      </div>
    </div>
  </div>
</div>
