@extends('layouts.production')
@section('content')
  <section class="content-header">
    <h1>
      {{ Trans('users.users')}}
      <small>{{ Trans('dashboard.crud.edit')}} : {{$user->first_name}}</small>
    </h1>
    <ol class="breadcrumb">
      <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
      <li><a href="{{ route('user.index')}}"><i class="fa fa-user"></i> Users</a></li>
      <li class="active">{{ Trans('dashboard.crud.edit')}}</li>
    </ol>
  </section>

  <!-- Main content -->

  <section class="content">
    @include('layouts.includes.message')
    {{ Form::model($user,['method'=>'patch','route'=>['user.update',$user->id],'files'=>true]) }}
    @include('users.inc.formv2')
    {{ Form::close() }}
  </section>

@endsection
@section('addJs')
  {{ HTML::script('plugins/datepicker/bootstrap-datepicker.js') }}
  {{ HTML::script('plugins/datepicker/locales/bootstrap-datepicker.kh.js') }}
  {{ HTML::script('production/js/webcam.js') }}
@endsection
