@extends('layouts.production')
@section('content')
  <section class="content-header">
    <h1>
      {{Trans("users.users")}}
      <small>{{Trans("dashboard.crud.add")}} {{Trans("dashboard.crud.new")}}</small>
    </h1>
    <ol class="breadcrumb">
      <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
      <li><a href="{{ route('user.index')}}"><i class="fa fa-user"></i> Users</a></li>
      <li class="active">Add</li>
    </ol>
  </section>

  <!-- Main content -->

  <section class="content">
    @include('layouts.includes.message')
    {{ Form::open(array('route' => 'user.store','method'=>'POST','files' => true)) }}
    @include('users.inc.formv2')
    {{ Form::close() }}
  </section>
@endsection
@section('addJs')
  {{ HTML::script('plugins/datepicker/bootstrap-datepicker.js') }}
  {{ HTML::script('plugins/datepicker/locales/bootstrap-datepicker.kh.js') }}
  {{ HTML::script('https://pixlcore.com/demos/webcamjs/webcam.min.js')}}
  {{ HTML::script('production/js/webcam.js') }}
@endsection
