@extends('layouts.production')
@section('content')
<section class="content-header">
  <h1>
    {{ Trans('purchases.menu') }}
  </h1>
  <ol class="breadcrumb">
    <li><a href="/"><i class="fa fa-dashboard"></i> {{ Trans('dashboard.home') }}</a></li>
    <li><a href="{{ route('suppliers.index')}}"><i class="fa fa-da"></i> {{ Trans('suppliers.menu') }}</a></li>
    <li class="active">{{ Trans('purchases.menu') }}</li>
  </ol>
</section>
<!-- Main content -->
<section class="content">
@include('layouts.includes.message')
<div class="row">
  <div class="col-md-3">
    <div class="box">
      <div class="box-header with-border">
        <h3 class="box-title">{{ trans('suppliers.menu') }}</h3>
      </div>
      <!-- /.box-header -->
      <div class="box-body">
        {{ Form::open(['method' => 'POST', 'route' => ['postSuppliers']]) }}
        <div class="form-group">
          {{ Form::label('company_name', trans('suppliers.company_name')) }}
          {{ Form::select('company_name', $suppliers, '1', [
            'class' => 'select2 form-control'
          ]) }}
        </div>
        <div class="form-group pull-right">
          <button type="submit" name="continue" class="btn btn-info">{{ trans('purchases.choose')}}</button>
        </div>
      </div>
    </div>
  </div>
</div>
@endsection
