@extends('layouts.production')
@section('content')
<section class="content-header">
  <h1>
    {{ Trans('purchases.menu') }}
    <small>{{ Trans('invoices.detail') }}</small>
  </h1>
  <ol class="breadcrumb">
    <li><a href="/"><i class="fa fa-dashboard"></i> {{ Trans('dashboard.home') }}</a></li>
    <li><a href="{{ Route('suppliers.index') }}"><i class="fa fa-building-o"></i> {{ Trans('suppliers.menu') }}</a></li>
    <li class="active">{{ Trans('purchases.menu') }}</li>
  </ol>
</section>
<!-- Main content -->
<section class="content">
@include('layouts.includes.message')
<div class="row">
  <div class="col-md-4">
    @include('suppliers.inc.table_details')
  </div>
  <div class="col-md-8">
    @include('suppliers.inc.table_products')
  </div>
</div>
@if(isset($sub_invoice) && count($sub_invoice))
  <div class="row">
    <div class="col-md-12">
      @include('suppliers.inc.table_sub_invoice')
    </div>
  </div>
@endif
</section>
@endsection
