@extends('layouts.production')
@section('content')
<section class="content-header">
  <h1>
    {{ Trans('suppliers.menu') }}
    <small>{{ Trans('suppliers.detail') }}</small>
  </h1>
  <ol class="breadcrumb">
    <li><a href="/"><i class="fa fa-dashboard"></i> {{ Trans('dashboard.home') }}</a></li>
    <li><a href="{{ Route('suppliers.index') }}"><i class="fa fa-building-o"></i> {{ Trans('suppliers.menu') }}</a></li>
    <li class="active">{{ $supplier->company_name }}</li>
  </ol>
</section>
<!-- Main content -->
<section class="content">
  @include('layouts.includes.message')
  <div class="row">
    <div class="col-md-6">
      <div class="box box-solid">
        <div class="box-header with-border">
          <h3 class="box-title">{{ Trans('suppliers.detail_com') }}</h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body">
          <div class="row">
            <div class="col-md-8">
              <table class="table table-striped table-bordered">
                <tr>
                  <th>{{ Trans('suppliers.company_name') }}</th>
                  <td>{{ $supplier->company_name }}</td>
                </tr>
                <tr>
                  <th>{{ Trans('suppliers.company_email') }}</th>
                  <td>{{ $supplier->company_email }}</td>
                </tr>
                <tr>
                  <th>{{ Trans('suppliers.tel') }}</th>
                  <td>{{ $supplier->tel }}</td>
                </tr>
                <tr>
                  <th>{{ Trans('suppliers.address') }}</th>
                  <td>{{ $supplier->address }}</td>
                </tr>

              </table>
            </div>
            <div class="col-md-4">
              {{ HTML::image($supplier->logo, $supplier->company_name, ['class' => 'img-responsive img-thumbnail']) }}
            </div>
          </div>
        </div>


        <!-- /.box-body -->
      </div>
      <!-- /.box -->
    </div>
    <div class="col-md-6">
      <div class="box box-solid">
        <div class="box-header with-border">
          <h3 class="box-title">{{ Trans('suppliers.detail_stuff') }}</h3>
        </div>
        <!-- /.box-header -->
          <div class="box-body">
            <div class="row">
              <div class="col-md-8">
                <table class="table table-striped table-bordered">
                  <tr>
                    <th>{{ Trans('suppliers.contact_name') }}</th>
                    <td>{{ $supplier->contact_name }}</td>
                  </tr>
                  <tr>
                    <th>{{ Trans('suppliers.position') }}</th>
                    <td>{{ $supplier->name }}</td>
                  </tr>
                  <tr>
                    <th>{{ Trans('suppliers.contact_email') }}</th>
                    <td>{{ $supplier->contact_email }}</td>
                  </tr>
                  <tr>
                    <th>{{ Trans('suppliers.tel') }}</th>
                    <td>{{ $supplier->contact_tel }}</td>
                  </tr>
                </table>
              </div>
              <div class="col-md-4">
                {{ HTML::image($supplier->contact_photo, $supplier->contact_name, ['class' => 'img-responsive img-thumbnail']) }}
              </div>
            </div>

          </div>

        <!-- /.box-body -->
      </div>
      <!-- /.box -->
    </div>

  </div>
  @if(UserRole::has('list_purchase_order'))
  <div class="row">
    <div class="col-md-12">
      @include('suppliers.inc.table_invoices')
    </div>
  </div>
  @endif
</section>
@endsection
@section('addJs')
<script>
  $(function () {
    $("#example2").DataTable();
    $('#example1').DataTable({
      "paging": true,
      "lengthChange": true,
      "searching": true,
      "ordering": false,
      "info": true,
      "autoWidth": false
    });
  });
</script>
<script type="text/javascript">
  function payment(id) {
      var data = {
        "payable": $("#pay"+id).val(),
        "referral_id": $("#referral_id"+id).val(),
        "invoice_id": id
      };
      $.ajax({
        type: "POST",
        url: '<?= route("supplierApprove") ?>',
        data: data,
        success: function(data) {
          toastr.options = {
            "progressBar": false,
            "positionClass": "toast-bottom-left",
            "hideMethod": "fadeOut"
          }
          if(data.error == true) {
            $("#msgForm"+id).addClass('has-error');
            toastr.error(data.msg);
          }  else {
            $("#msgForm"+id).removeClass('has-error');
            toastr.success(data.msg);
            $("#payable"+id).modal('hide');
            location.reload();
          }
        }
      });
  }
  $(document).ready(function() {
    $(":submit").on('click', function(e){
      e.preventDefault();
    });
  });
</script>
@endsection
