@extends('layouts.production')
@section('content')
<section class="content-header">
  <h1>
    {{ Trans('suppliers.menu') }}
    <small>{{ Trans('suppliers.show') }}</small>
  </h1>
  <ol class="breadcrumb">
    <li><a href="/"><i class="fa fa-dashboard"></i> {{ Trans('dashboard.home') }}</a></li>
    <li class="active">{{ Trans('suppliers.menu') }}</li>
  </ol>
</section>
<!-- Main content -->
<section class="content">
@include('layouts.includes.message')
<div class="row">
  <div class="col-md-12">
    <div class="box">
      <!-- /.box-header -->
      <div class="box-body">
        <table id="example1" class="table table-bordered table-striped">
          <thead>
            <tr>
              <th>#</th>
              <th>{{ Trans('suppliers.company_name') }}</th>
              <th>{{ Trans('suppliers.tel') }}</th>
              @if(UserRole::has('edit_supplier') || UserRole::has('delete_supplier'))
              <th>{{ Trans('dashboard.crud.actions') }}</th>
              @endif
            </tr>
          </thead>
          <tbody>
            @foreach($suppliers as $supplier)
              <tr>
                <td>{{ $supplier->id }}</td>
                <td>{{link_to_route('suppliers.show', $supplier->company_name, [$supplier->id]) }}</td>
                <td>{{ $supplier->tel }}</td>
                @if(UserRole::has('edit_supplier') || UserRole::has('delete_supplier'))
                <td>
                  {{link_to_route('suppliers.show', trans('dashboard.others.detail'), [$supplier->id], ['class' => "btn btn-xs btn-default"]) }}
                  @if(UserRole::has("edit_supplier"))
                    <a href="{{ Route("suppliers.edit",$supplier->id) }}" class="btn btn-xs btn-info">{{Trans("dashboard.crud.edit")}}</a>
                  @endif
                  @if(UserRole::has("delete_supplier"))
                    <a href="#" class="btn btn-xs btn-danger" data-toggle="modal" data-target="#myModal{{$supplier->id}}">{{Trans("dashboard.crud.remove")}}</a>
                    @include('layouts.includes.modals.danger', ['model' => $supplier,'toRoute'=>'suppliers','attribute'=>'company_name'])
                  @endif
                </td>
                @endif
              </tr>
            @endforeach
          </table>
        </div>
        <!-- /.box-body -->
      </div>
      <!-- /.box -->
    </div>
  </div>
  {{ Form::close() }}
</section>
@endsection
@section('addJs')
<script>
  $(function () {
    $("#example1").DataTable();
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": true,
      "info": true,
      "autoWidth": false
    });
  });
</script>
@endsection
