
<div class="box">
  <div class="box-header with-border">
    <h3 class="box-title">{{ trans('purchases.menu')}}</h3>
    @if(UserRole::has('create_purchase_order'))
    <a href="{{ route('purchaseOrder', $supplier->id)}}" class="btn btn-xs btn-default pull-right"><i class="fa fa-plus"></i> {{ trans('dashboard.crud.add')}}</a>
    @endif
  </div>
  <div class="box-body">
    <table class="table table-striped table-bordered" id='example1'>
      <thead>
        <tr>
          <th>{{ trans('invoices.id')}}</th>
          <th>{{ trans('invoices.total')}}</th>
          <th>{{ trans('invoices.pay')}}</th>
          <th>{{ trans('invoices.payable')}}</th>
          <th>{{ trans('invoices.status')}}</th>
          @if(UserRole::has('print_purchase_order')
            || UserRole::has('detail_purchase_order')
            || UserRole::has('approve_purchase_order'))
          <th>{{ trans('dashboard.crud.actions')}}</th>
          @endif
        </tr>
      </thead>
      <tbody>
      @foreach($invoices as $invoice)
        @include('suppliers.inc.payable')
        <tr>
          <td>{{ $invoice->id }}</td>
          <td>{{ money($invoice->total) }}</td>
          <td>{{ money($invoice->pay) }}</td>
          <td>{{ money($invoice->payable) }}</td>
          <td>
            @if($invoice->status == "paid")
              <span class="label label-success">
            @elseif($invoice->status == 'deposit')
              <span class="label label-primary">
            @else
              <span class="label label-default">
            @endif
            {{ $invoice->status }}</span></td>
          @if(UserRole::has('print_purchase_order')
            || UserRole::has('detail_purchase_order')
            || UserRole::has('approve_purchase_order'))
          <td>
            @if(UserRole::has('print_purchase_order'))
            <a href='{{ route("supInvoicePrint", [$supplier->id, $invoice->id])}}' class="btn btn-xs btn-default" target="_blank"> <i class="fa fa-print"></i> {{ trans('reports.print')}}</a>
            @endif
            @if(UserRole::has('detail_purchase_order'))
            {{ link_to_route('supInvoices', trans('dashboard.others.detail'), [$supplier->id, $invoice->id], ['class' => 'btn btn-xs btn-info'])}}
            @endif
            @if(UserRole::has('approve_purchase_order'))
              @if($invoice->status == "paid")
                <button class="btn btn-xs btn-default disabled" data-toggle="modal" data-target="#payable">Approved</button>
              @else
                <button class="btn btn-xs btn-success" data-toggle="modal" data-target="#payable{{$invoice->id}}">Approve</button>
              @endif
            @endif
          </td>
          @endif
        </tr>
      @endforeach
      </tbody>
    </table>
  </div>
</div>
