<div class="box">
  <div class="box-header with-border">
    <h3 class="box-title">{{ trans('invoices.menu')}}</h3>
  </div>
  <!-- /.box-header -->
  <div class="box-body">
    <table class="table table-striped table-bordered">
      <tr>
        <th>{{ trans('invoices.id') }}</th>
        <td>#{{ $detail->id }}</td>
      </tr>
      <tr>
        <th>{{ trans('invoices.total') }}</th>
        <td>{{ money($detail->total) }}</td>
      </tr>
      @if($detail->pay > 0)
      <tr>
        <th>{{ trans('invoices.pay') }}</th>
        <td>{{ money($detail->pay) }}</td>
      </tr>
      @endif
      @if($detail->changed > 0)
        <tr>
          <th>{{ trans('invoices.changed') }}</th>
          <td>{{ money($detail->changed) }}</td>
        </tr>
      @endif
      @if($detail->payable > 0)
      <tr>
        <th>{{ trans('invoices.payable') }}</th>
        <td>{{ money($detail->payable) }}</td>
      </tr>
      @endif
      <tr>
        <th>{{ trans('invoices.status') }}</th>
        <td>
          @if($detail->status == "paid")
            <span class="label label-success">
          @elseif($detail->status == 'deposit')
            <span class="label label-primary">
          @else
            <span class="label label-default">
          @endif
          {{ $detail->status }}</span></td>
        </td>
      </tr>
    </table>
  </div>
</div>
