
<!DOCTYPE html>
<html>
<head>
  <title>Purchase Order</title>
  {{ HTML::style('assets/vendor/bootstrap/dist/css/bootstrap.min.css') }}
  {{ HTML::style('css/purchase.css') }}
</head>
<body>
  <div class="container">
    <div class="row">
      <div class="col-xs-6 col-sm-6 col-md-8 ">
        <h2>{{ \Helper::getConfig('company_name')}}</h2>
        <address>
          <abbr>Address:</abbr>
          {{ \Helper::getConfig('company_address')}}<br>
          <abbr>Tel:</abbr> {{ \Helper::getConfig('company_tel')}} <br>
          <abbr>Email:</abbr> {{ \Helper::getConfig('company_email')}} <br>
          <abbr>Website:</abbr> {{ \Helper::getConfig('company_website')}} <br>
        </address>
        </div>
        <div class="col-xs-6 col-sm-6 col-md-4">
          <h3 class="text-right">Purchase Order</h3>
          <dl class="dl-horizontal">
            <dt>Date :</dt>
            <dd>{{ $detail->created_at}}</dd>
            <dt>POID :</dt>
            <dd>#{{ $detail->id}}</dd>
          </dl>
        </div>
    </div>
    <hr>
    <div class="row">
      <div class="col-xs-6 col-sm-6 col-md-6">
        <h4>Purchase From:</h4>
        <dl class="dl-horizontal">
          <dt>Supplier Name:</dt>
          <dd>{{ $detail->company_name }}</dd>
          <dt>Tel:</dt>
          <dd>{{ $detail->tel}}</dd>
          <dt>Contact Tel:</dt>
          <dd>{{ $detail->contact_tel}}</dd>
          <dt>Address:</dt>
          <dd>{{ $detail->address}}</dd>
          <dt>Attention To:</dt>
          <dd>{{ $detail->contact_name}}</dd>
        </dl>
      </div>
      <div class="col-xs-6 col-sm-6 col-md-6">
        <h4>Ship To:</h4>
        <dl class="dl-horizontal">
          <dt>Company Name:</dt>
          <dd>{{ \Helper::getConfig('company_name')}}</dd>
          <dt>Contact Tel:</dt>
          <dd>{{ $detail->user_tel}}</dd>
          <dt>Address:</dt>
          <dd>{{ \Helper::getConfig('company_address')}}</dd>
          <dt>Attention To:</dt>
          <dd>{{ $detail->first_name}}</dd>
        </dl>
      </div>
      <br>
    </div>
    <div class="row">
      <div class="col-md-12">
        <table>
          <thead>
            <tr>
              <th>Barcode</th>
              <th>Details</th>
              <th>Quantity</th>
              <th>Unit Price</th>
              <th>Total</th>
            </tr>
          </thead>
          <tbody>
            <?php
              $total = 0;
             ?>
            @foreach($products as $product)
              <?php
                $total += $product->amount * $product->price_in;
               ?>
              <tr>
                <td>{{ $product->sku }}</td>
                <td>{{ $product->name}}</td>
                <td>{{ $product->amount}}</td>
                <td>{{ money($product->price_in)}}</td>
                <td>{{ money($product->amount * $product->price_in)}}</td>
              </tr>
            @endforeach

            <tr>
              <td colspan="3" rowspan="3" id="merge">
                <dl class="dl-horizontal status">
                  <dt>Status</dt>
                  <dd>{{ $detail->status}}</dd>
                  <dt>Payment</dt>
                  <dd>{{ money($detail->pay)}}</dd>
                  <dt>Payable</dt>
                  <dd>{{ money($detail->payable)}}</dd>
                </dl>
              </td>
              <td><b>Sub Total</b></td>
              <td>{{ money($total)}}</td>
            </tr>
            <tr>
              <td><b>Tax</b></td>
              <td>{{ $detail->tax }} %</td>
            </tr>
            <tr>
              <td><b>Total</b></td>
              <td>{{ money($detail->total)}}</td>
            </tr>
          </tbody>
        </table>
      </div>
    </div>
  </div>
  {{ HTML::script('assets/vendor/jquery/dist/jquery.min.js') }}
  <script type="text/javascript">
    $(document).ready(function(){
      window.print();
    });
  </script>
</body>
</html>
