<div class="row">
  <div class="col-md-6">
    <div class="box">
      <div class="box-header with-border">
        <h3 class="box-title">{{ trans('suppliers.menu')}}</h3>
      </div>
      <div class="box-body">
        <div class="row">
          <div class="col-md-6 form-group">
            {{ Form::label("company_name", Trans("suppliers.company_name")) }}
            {{ Form::text("company_name", null, [
              'class'  => 'form-control',
              'placeholder'  => Trans("suppliers.company_name"),
              'required'  =>  "required"
            ])}}
            @if(isset($errors))
              <span class="inline-helper text-danger">{{ $errors->first('company_name')}}</span>
            @endif
          </div>
          <div class="col-md-6 form-group">
            {{ Form::label("tel", Trans("suppliers.tel")) }}
            {{ Form::text("tel", null, [
              'class'  => 'form-control',
              'placeholder'  => Trans("suppliers.tel"),
              'required'  =>  "required"
            ])}}
            @if(isset($errors))
              <span class="inline-helper text-danger">{{ $errors->first('tel')}}</span>
            @endif
          </div>
        </div>
        <div class="row">
          <div class="col-md-6 form-group">
            {{ Form::label("company_email", Trans("suppliers.company_email")) }}
            {{ Form::email("company_email", null, [
              'class'  => 'form-control',
              'placeholder'  => Trans("suppliers.company_email")
            ])}}
            @if(isset($errors))
              <span class="inline-helper text-danger">{{ $errors->first('company_email')}}</span>
            @endif
          </div>
          <div class="col-md-6 form-group">
            {{ Form::label("logo", Trans("suppliers.logo")) }}
            {{ Form::file("logo", [
              'class'  => 'form-control',
              'placeholder'  => Trans("suppliers.logo")
            ])}}
          </div>
        </div>
        <div class="row">
          <div class="col-md-6 form-group">
            {{ Form::label("address", Trans("suppliers.address")) }}
            {{ Form::textarea("address", null, [
              'class'  => 'form-control',
              'placeholder'  => Trans("suppliers.address"),
              'rows'  =>  '3'
            ])}}
          </div>
          <div class="col-md-6">
            @if (isset($supplier))
              <img src="{{$supplier->logo}}" alt="" class="img-responsive img-thumbnail thumbnail-photo-edit">
              <br><br>
            @endif
          </div>
        </div>
      <div class="row">
        <div class="col-md-12">
          <div class="pull-right">
            <button type="submit" name="submit" class="btn btn-info">
              @if(isset($supplier->id))
                {{ Trans('dashboard.crud.update') }}
              @else
                {{ Trans('dashboard.crud.add') }}
              @endif
              </button>
            <button type="reset" name="reset" class="btn btn-default">{{ Trans('dashboard.crud.reset') }}</button>
          </div>
        </div>
      </div>
      </div>

    </div>
  </div>
  <div class="col-md-6">
    <div class="box">
      <div class="box-header with-border">
        <h3 class="box-title">{{ trans('suppliers.staff') }}</h3>
      </div>
      <div class="box-body">
        <div class="row">
          <div class="col-md-6 form-group">
            {{ Form::label("contact_name", Trans("suppliers.contact_name")) }}
            {{ Form::text("contact_name", null, [
              'class'  => 'form-control',
              'placeholder'  => Trans("suppliers.contact_name"),
              'required'  =>  "required"
            ])}}
          </div>
          <div class="col-md-6 form-group">
            {{ Form::label("contact_tel", Trans("suppliers.contact_tel")) }}
            {{ Form::text("contact_tel", null, [
              'class'  => 'form-control',
              'placeholder'  => Trans("suppliers.contact_tel"),
              'required'  =>  "required"
            ])}}
            @if(isset($errors))
              <span class="inline-helper text-danger">{{ $errors->first('contact_tel')}}</span>
            @endif
          </div>
        </div>
        <div class="row">
          <div class="col-md-6 form-group">
            {{ Form::label("contact_email", Trans("suppliers.contact_email")) }}
            {{ Form::email("contact_email", null, [
              'class'  => 'form-control',
              'placeholder'  => Trans("suppliers.contact_email")
            ])}}
            @if(isset($errors))
              <span class="inline-helper text-danger">{{ $errors->first('contact_email')}}</span>
            @endif
          </div>
          <div class="col-md-6 form-group">
            <?php
            $selected = isset($supplier) ? $supplier->position_id : "0";
            ?>
            {{ Form::label("position_id", Trans("suppliers.position")) }}
            {{ Form::select("position_id", $positions, $selected, [
              'class'  => 'form-control select2'
            ])}}
          </div>
        </div>
        <div class="row">
          <div class="col-md-6 form-group">
            {{ Form::label("contact_photo", Trans("suppliers.contact_photo")) }}
            {{ Form::file("contact_photo",[
              'class'  => 'form-control',
              'placeholder'  => Trans("suppliers.contact_photo")
            ])}}
          </div>
          @if (isset($supplier))
          <div class="col-md-6">
              <img src="{{$supplier->contact_photo}}" alt="" class="img-responsive img-thumbnail thumbnail-photo-edit">
              <br><br>
          </div>
          @endif
        </div>
      </div>

    </div>
  </div>
</div>
