@extends('layouts.production')
@section('content')
  <section class="content-header">
    <h1>
      {{ Trans('stock.stock') }}
      <small>{{ getField("Stock","id",$stock->id,"name") }}</small>
    </h1>
    <ol class="breadcrumb">
      <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
      <li class="active">{{ Trans('stock.stock') }}</li>
    </ol>
  </section>
  <!-- Main content -->
  <section class="content">
  @include('layouts.includes.message')
    <div class="row">
      <div class="col-md-12">
        <div class="box">
				  <!-- /.box-header -->
				  <div class="box-body">
				    <table id="example1" class="table table-bordered table-striped">
				    </table>
				  </div>
				  <!-- /.box-body -->
				</div>
				<!-- /.box -->
      </div>
    </div>
    {{ Form::close() }}
  </section>
@endsection
@section('addJs')
  <script>
    $(function () {
      $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });
      $("#example1").DataTable({
        "ajax"        : "{{Route('getStockProducts',$stock->id)}}",
        "processing"  : true,
        "serverSide"  : true,
        "paging": true,
        "autoWidth": true,
        "columnDefs": [
          { "searchable": false, "targets": 8 },
          { 'className': "hidden-md hidden-sm", "targets": [2,7]}
        ],
        "columns": [
<<<<<<< HEAD
            {data: 'sku', name: 'products.sku',title: '{{ Trans('products.sku') }}'},
            {data: 'name', name: 'products.name',title: '{{ Trans('products.name') }}'},
            {data: 'name_kh', name: 'products.name_kh',title: '{{ Trans('products.name_kh') }}'},
            {data: 'amount', name: 'outlets.amount',title: '{{ Trans('products.amount') }}'},
            {data: 'on_hold', name: 'outlets.on_hold',title: '{{ Trans('products.on_hold') }}'},
            {data: 'available_amount', name: 'outlets.available_amount',title: '{{ Trans('products.available_amount') }}'},
            {data: 'price_in', name: 'products.price_in',title: '{{ Trans('products.price_in') }}'},
            {data: 'price', name: 'products.price',title: '{{ Trans('products.price') }}'},
            {data: 'created_by', name: 'outlets.user_id',title: '{{ Trans('dashboard.crud.created_by') }}'},
            {data: 'cName', name: 'productcategories.name',title: '{{ Trans('products.product_category') }}'},
=======
            {data: 'sku', name: 'p.sku',title: '{{ Trans('products.sku') }}'},
            {data: 'name', name: 'p.name',title: '{{ Trans('products.name') }}'},
            {data: 'amount', name: 'o.amount',title: '{{ Trans('products.amount') }}'},
            {data: 'on_hold', name: 'o.on_hold',title: '{{ Trans('products.on_hold') }}'},
            {data: 'available_amount', name: 'o.available_amount',title: '{{ Trans('products.available_amount') }}'},
            {data: 'price', name: 'o.price',title: '{{ Trans('products.price') }}'},
            {data: 'category', name: 'pc.name',title: '{{ Trans('products.product_category') }}'},
            {data: 'location', name: 'o.location',title: '{{ Trans('products.box_id') }}'},
>>>>>>> staging_kubuta
            {data: 'action', name: 'action',title: '{{ Trans('dashboard.crud.actions') }}'},

        ],
        initComplete: function () {
          this.api().columns([1,2,3]).every(function () {
              var column = this;
              var input = document.createElement("input");
              $(input).appendTo($(column.footer()).empty())
              .on('change', function () {
                  var val = $.fn.dataTable.util.escapeRegex($(this).val());
                  column.search(val ? val : '', true, false).draw();
              });
          });
        }
      });
    });
  </script>
@endsection
