@extends('layouts.production')
@section('content')
  <section class="content-header">
    <h1>
      {{ Trans('stock.stock') }}
      <small>{{ Trans('suppliers.show') }}</small>
    </h1>
    <ol class="breadcrumb">
      <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
      <li class="active">{{ Trans('stock.stock') }}</li>
    </ol>
  </section>
  <!-- Main content -->
  <section class="content">
    @include('layouts.includes.message')
    <div class="box box-body">
      <table class="table table-bordered" id="example1">
        <thead>
          <tr>
            <th>#</th>
            <th>{{ Trans('stock.stock')}}</th>
            <th>{{ Trans('dashboard.branches.branch')}}</th>
            <th>{{ Trans('dashboard.crud.created_at')}}</th>
            <th>{{ Trans('dashboard.crud.actions')}}</th>
          </tr>
        </thead>
        <tbody>
          @foreach($stocks as $stock)
            <tr>
              <td>{{ $stock->id }}</td>
              <td>{{ $stock->name }}</td>
              <td>{{ $stock->branch_name }}</td>
              <td>{{ formatDate($stock->created_at) }}</td>
              <td>
                @if(UserRole::has("edit_stock"))
                  <a href="{{ Route("stocks.edit",$stock->id) }}" class="btn btn-xs btn-info"><i class="fa fa-edit"></i> {{Trans("dashboard.crud.edit")}}</a>
                @endif
                <a href="{{ Route("stocks.show",$stock->id) }}" class="btn btn-xs btn-info"><i class="fa fa-th-list"></i> {{Trans("dashboard.crud.open")}}</a>
              </td>
            </tr>
          @if(Stock::getNumber() == 'one')
            <?php break; ?>
          @endif
          @endforeach
        </tbody>
      </table>
    </div>
  </section>
@endsection
@section('addJs')
  <script>
  $(function () {
    $("#example1").DataTable();
  });
  </script>
@endsection
