@extends('layouts.production')
@section('content')
    <section class="content-header">
        <h1>
            {{ Trans('settings.settings') }}
        </h1>
    </section>
    <!-- Main content -->
    <section class="content">
    @include('layouts.includes.message')
    <!-- START CUSTOM TABS -->
        <div class="row">
            <div class="col-md-12">
                <div class="box">
                    <div class="box-header with-border">
                        <h3 class="box-title">Logo & Banner</h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-3">
                                {{ HTML::image(get_config('company_logo'), "Logo", [
                                    'width' => '200px;', 'class' => 'logo img-thumbnail'
                                ])}}
                            </div>
                            <div class="col-md-6">
                                {{ HTML::image(get_config('company_banner'), "Banner", [
						            'class' => 'company_banner img-thumbnail',
						            'width' => '200px;'
					            ]) }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <!-- Custom Tabs -->
                <div class="nav-tabs-custom">
                    <ul class="nav nav-tabs">
                        <li class="active"><a href="#tab_1" data-toggle="tab"><i class="fa fa-building-o"></i> {{Trans('settings.company_info')}}</a>
                        </li>
                        <li><a href="#tab_2" data-toggle="tab"><i class="fa fa-calendar-o"></i> {{Trans('settings.invoice_setting')}}</a></li>
                        <li><a href="#tab_3" data-toggle="tab"><i class="fa fa-credit-card"></i> {{Trans('settings.mortgage_setting')}}</a></li>
                        <li><a href="#tab_4" data-toggle="tab"><i class="fa fa-code"></i> Custom Style</a></li>
                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane active" id="tab_1">
                            @include('settings.inc.company')
                        </div>
                        <div class="tab-pane" id="tab_3">
                            @include('settings.inc.mortgage')
                        </div>
                        <div class="tab-pane" id="tab_4">
                            @include('settings.inc.style')
                        </div>
                        <!-- /.tab-pane -->
                        <div class="tab-pane" id="tab_2">
                            @include("settings.inc.installment")
                        </div>
                        <!-- /.tab-pane -->
                    </div>
                    <!-- /.tab-content -->
                </div>
                <!-- nav-tabs-custom -->
            </div>
        </div>
        <!-- /.row -->
        <!-- END CUSTOM TABS -->
    </section>
@endsection