{{ Form::open(array('route' => 'settings.store','method'=>'POST','files' => true,'class'=>'display inline-block')) }}
@foreach($invoice as $key)
    <div class="col-md-4 form-group">
        {{ Form::label($key->meta_key, Trans('settings.'.$key->meta_key)) }}
        @if($key->meta_key == 'invoice_type')
            <?php
            $printers = [
                'normal-print' => 'Normal Printer',
                'terminal-printer' => 'Terminal Printer'
            ];
            ?>
            {{ Form::select($key->meta_key,$printers,$key->meta_value,['class'=>'form-control'])}}
        @elseif($key->meta_key == 'invoice_currency')
            <?php
            $currency = ['riel' => 'រៀល', 'usd' => 'ដុល្លារ', 'baht' => "បាត"];
            ?>
            {{ Form::select($key->meta_key,$currency,$key->meta_value,['class'=>'form-control'])}}
        @elseif($key->meta_key == 'second_invoice_currency')
            <?php
            $currency = ['riel' => 'រៀល', 'usd' => 'ដុល្លារ'];
            ?>
            {{ Form::select($key->meta_key,$currency,$key->meta_value,['class'=>'form-control'])}}
        @elseif($key->meta_key == "variable_price")
            <?php
            $type = [
                'before' => "ខែដំបូង",
                'after' => "ខែចុងក្រោយ"
            ];
            ?>
            {{ Form::select($key->meta_key, $type, $key->meta_value, ['class' => "form-control select2"]) }}
        @elseif($key->meta_key == 'format_khmer_currency')
            <?php
            $options = [
                'yes' => trans('settings.yes'),
                'no' => trans('settings.no')
            ];
            ?>
            {{ Form::select($key->meta_key, $options, $key->meta_value,['class' => "form-control"]) }}
        @elseif ($key->meta_key == "min_amount_return")
            <?php
            $min_amount = [
                25 => "25%",
                50 => "50%",
                75 => "75%",
                100 => "100%"
            ];
            ?>
            {{ Form::select($key->meta_key,$min_amount,$key->meta_value,['class'=>'form-control'])}}
        @elseif ($key->meta_key == "enable_sale_out_of_stock")
            <?php
            $options = [
                1 => "Yes",
                0 => "No"
            ];
            ?>
            {{ Form::select($key->meta_key,$options,$key->meta_value,['class'=>'form-control'])}}
        @elseif ($key->meta_key == "style_sale")
            <?php
            $options = [
                "table" => "Table",
                'list' => "List"
            ];
            ?>
            {{ Form::select($key->meta_key,$options,$key->meta_value,['class'=>'form-control'])}}
        @else
            <?php $type = $key->input_type; ?>
            {{ Form::$type($key->meta_key, $key->meta_value, [
                'class' => 'form-control',
                'placeholder' => Trans('settings.'.$key->meta_key),
                'rows'	=> '3',
                        'step'=>'any',
                            'min'=>0
            ])}}

        @endif
    </div>
@endforeach
<div class="row">
    <div class="col-md-12">
        <hr>
        <div class="pull-right">
            <button type="submit" name="submit"
                    class="btn btn-info">{{ Trans('dashboard.crud.update') }}</button>
            <button type="reset" name="reset"
                    class="btn btn-default">{{ Trans('buttons.reset') }}</button>
        </div>
    </div>
</div>
{{ Form::close()}}