@extends('layouts.production')
@section('content')
  <section class="content-header">
    <h1>
      {{ Trans('services.menu') }}
    </h1>

    <ol class="breadcrumb">
      <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
      <li><a href="{{ route('services.index') }}">{{ Trans('services.menu') }}</a></li>
      <li class="active">{{ trans('dashboard.others.detail') }}
    </ol>
  </section>
  <!-- Main content -->
  <section class="content">
    @include('layouts.includes.message')
    <div class="row">
      <div class="col-md-12">
        <div class="box">
          <div class="box-header with-border">
            <h3 class="box-title">{{ trans('dashboard.others.info') }} </h3>
          </div>
          <div class="box-body">
              <div class="row">
                <div class="col-md-6">
                  <table class="table table-striped table-bordered">
                    <tr>
                      <th>{{ trans('services.tel') }}</th>
                      <td>{{ $service->tel }}</td>
                    </tr>
                     <tr>
                      <th>{{ trans('services.name') }}</th>
                      <td>{{ $service->product_name }}</td>
                    </tr>
                     <tr>
                      <th>{{ trans('services.model') }}</th>
                      <td>{{ $service->model }}</td>
                    </tr>
                     <tr>
                      <th>{{ trans('services.duration') }}</th>
                      <td>{{ trans('services.durations.'.$service->duration) }}</td>
                    </tr>
                     <tr>
                      <th>{{ trans('services.note') }}</th>
                      <td>{{ $service->note }}</td>
                    </tr>
                    <tr>
                      <th>{{ trans('services.is_warranty') }}</th>
                      <td>{{ $service->is_warranty ? "Yes" : "No" }} <span class="label lable-info">{{ $service->is_send  ? "Send" : ""}}</span></td>
                    </tr>

                  </table>
                </div>
                <div class="col-md-6">
                  {{ Form::open(['route' => 'services.updateDetail']) }}
                    {{ Form::hidden('service_id', $service->id) }}
                  @if ($service->is_send)
                   <div class="form-group">
                        <div class="form-group">
                          <label>{{ trans('services.send_date') }}</label>
                          <div>
                            <p class="form-control-static">{{ d_format($service->send_date) }}</p>
                          </div>
                        </div>
                        {{ Form::label('recieved_date', Trans('services.recieved_date')) }}
                        <div class="input-group date">
                          {{ Form::text('recieved_date', $service->recieved_date ? $service->recieved_date : null, [
                            'class' => "form-control",
                            'placeholder' => Trans('services.recieved_date'),
                            'required'    =>  "required",
                            ($service->status == "completed" || $service->status == "paid") ? 'disabled' : '',
                            'id'  =>  "recieved_date"
                          ]) }}
                          <div class="input-group-addon">
                              <i class="fa fa-calendar"></i>
                          </div>
                        </div>
                      </div>
                    @endif
                    <div class="form-group">
                      <label for="detail">{{ trans('services.detail') }}</label>
                      {{ Form::textarea('detail', $service->detail, [
                        'class' => "form-control",
                        'rows'  =>  "3",
                        'required' => "required",
                        ($service->status == "completed" || $service->status == "paid") ? 'disabled' : '',
                        'placeholder' =>  trans('services.detail')
                      ]) }}
                    </div>
                    <div class="form-group">
                      <label for="service_charge">{{ trans('services.charge') }}</label>
                        {{ Form::number('service_charge', $service->price, [
                          'class' => "form-control",
                         ($service->status == "completed" || $service->status == "paid") ? 'disabled' : '',
                          'placeholder' =>  trans('services.charge')
                        ]) }}
                    </div>
                  <div class="pull-right">
                    @if ($service->status == "pendding")
                    <button type="submit" class="btn btn-default" name="repairing" value="1"><i class="fa fa-wrench"></i> {{ trans('services.repairing') }}</button>
                    @endif
                    @if ($service->status == "repairing")
                    <button type="submit" class="btn btn-success" name="completed" value="1"><i class="fa fa-check-circle-o"></i> {{ trans('services.completed') }}</button>
                    @endif
                  </div>
                  {{ Form::close() }}
                </div>
              </div>
          </div>
        </div>
      </div>
    </div>
  </section>
@endsection
@section('addJs')
  {{ HTML::script('plugins/datepicker/bootstrap-datepicker.js') }}
  {{ HTML::script('plugins/datepicker/locales/bootstrap-datepicker.kh.js') }}
  <script>
   $(function () {
     $('#recieved_date').datepicker({
      todayHighlight: true,
      format: 'd/m/yyyy',
    });
   });
  </script> 
@endsection
