<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="UTF-8">
	<title>Receipt</title>
	{{ HTML::style("css/bootstrap.css") }}
	<style media="print">
		@page { margin: 0; padding: 0; }
		p.sign { border-top: 1px solid #000 !important;}
		img { margin-top: 20px; }
	</style>
	<style>
		p.sign { border-top: 1px solid #000 !important;}
		#check { border: 1px solid #ddd;width: 15px;height: 15px;padding: 5px;display: inline-block;}
		.address { text-align: right !important; font-size: 12px; color:green;}
		.address p { margin: 0; }
		hgroup h2 {font-family: "Khmer OS Muol" !important; margin-bottom: 0px;}
		hgroup h2:last-child { margin-top: 5px; }
		h3 { text-align: center; font-size: 16px; font-family: "Khemr OS Muol"; font-style: italic; padding-bottom: 5px; border-bottom: 3px solid #ddd; border-width: 100%; margin-top: 30px; }
		.content { min-height: 345px; }
	</style>
</head>
<body onload="window.print()">
	<div class="container">
		<div class="row">
			<div class="col-xs-4">
				{{ HTML::image('uploads/network.jpg', "Logo", [
						'width' => '100px',
				]) }}
			</div>
			<div class="col-xs-8">
					<hgroup>
						<h2 style="color: blue;">ណិតវឺក កុំព្យូទ័រ</h2>
						<h2 style="color: red; font-weight: bold;">Network Computer</h2>
					</hgroup>					
			</div>
		</div>
		<div class="row">
			<div class="col-xs-5">
				<h3>បង្កាន់ដៃទទួលជួសជុល</h3>
			</div>
			<div class="col-xs-7 address">
				<p>#095, Gr. 09, Svay Por Dirstrict, Battambang</p>
				<p>Phone: 053 953 124, 098 655 596</p>
				<p>Open: Monday - Saturday</p>
				<p>8:00 am - 5:30 pm</p>
			</div>
		</div>
		<div class="row">
			<div class="col-xs-12">
				<table class="table table-bordered" style="margin-bottom: 0;">
					<tr>
						<td>Date : {{ $service->created_at }}</td>
						<td>Receipt N<sup>o</sup>: {{ convertInvoiceNumber($service->id) }}</td>
					</tr>
				</table>
			</div>
			<div class="col-xs-12">
				<table class="table table-bordered">
					<tr>
						<td><div id="check"></div> 3 Days</td>
						<td><div id="check"></div> 7 Days</td>
						<td><div id="check"></div> 10 Days</td>
						<td><div id="check"></div> Delay Till</td>
					</tr>
				</table>
			</div>
			<div class="col-xs-12">
				<div class="content">
					<table class="table table-bordered">
					<tr>
						<th style="width: 25%;">{{ trans('services.name') }}</th>
						<td>{{ $service->product_name }}</td>
					</tr>
					<tr>
						<th>{{ trans('services.model') }}</th>
						<td>{{ $service->model }}</td>
					</tr>
					<tr>
						<th>{{ trans('services.note') }}</th>
						<td>{{ $service->note }}</td>
					</tr>
					<tr>
						<th>{{ trans('services.detail') }}</th>
						@if ($service->detail)
						<td>{{ $service->detail }}</td>
						@else
						<td><br><br></td>
						@endif
					</tr>
					<tr>
						<th>{{ trans('services.charge') }}</th>
						@if ($service->price > 0)
						<td>{{ money($service->price) }}</td>
						@else 
						<td><br></td>
						@endif
					</tr>
					<tr>
						<th>{{ trans('services.others') }}</th>
						<td>{{ $service->others }}</td>
					</tr>
				</table>
				</div>
			</div>
		</div>
		<div class="row">
			<div class="col-xs-12">
				<table class="table text-center" style="margin-bottom: 0;">
				<tr>
					<td>{{ $service->tel }}</td>
					<td></td>
				</tr>
				<tr>
					<td>{{ trans('services.tel') }}</td>
					<td>{{ trans('services.sign') }}</td>
				</tr>
			</table>
			</div>
			<div class="col-xs-12">
				<p class="text-center" style="border: 1px solid #ddd; padding: 5px;">កត់ចំណាំ: យើងខ្ញុំមិនទទួលខុសត្រូវ រាល់ការបាត់បង់ឯកសារ កម្មវិធី នឹង ករណី កើតឡើងដោយចៃដន្យណាមួយ ក្រោយពេលដែលយកមកជួសជុលនោះទេ។ សូមរក្សាចុងសន្លឹកទុកដើម្បីធ្វើការផ្តៀងផ្ទាត់ពេលក្រោយ។ លក្ខ័ណ្ឌផ្រេងៗត្រូវបានអនុវត្តន៏</p>
			</div>
		</div>
	</div>
</body>
</html>