@extends('layouts.production')
@section('addCss')
  <style>
    .label { font-style: italic; font-weight: normal; padding: 5px; }
  </style>
@endsection
@section('content')
  <section class="content-header">
    <h1>
      {{ Trans('services.menu') }}
    </h1>

    <ol class="breadcrumb">
      <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
      <li><a href="{{ route('services.index') }}">{{ Trans('services.menu') }}</a></li>
      <li class="active">{{ trans('dashboard.others.show_all') }}
    </ol>
  </section>
  <!-- Main content -->
  <section class="content">
    @include('layouts.includes.message')
    <div class="row">
      <div class="col-md-12">
        <div class="box">
          <div class="box-header with-border">
            <div class="row">
           {{ Form::open(['method' => 'get']) }}
           <div class="col-md-2">
             <div class="form-group">
               <?php
               $value = Request::get('invoice_id') ? Request::get('invoice_id') : null;

                ?>
               {{ Form::text('invoice_id', $value, [
                 'class' => 'form-control',
                 'placeholder' =>  trans('invoices.id')
               ]) }}
             </div>
           </div>
             <div class="col-md-3">
               <div class="form-group">
                 <div class="input-group date" data-provide="datepicker">
                   <?php
                   $value = Request::get('start_date') ? Request::get('start_date') : null;

                    ?>
                   {{ Form::text('start_date', $value, [
                     'class' => "form-control",
                     'placeholder' => Trans('invoices.start_date'),
                     'autocomplete' => "off"
                   ]) }}
                   <div class="input-group-addon">
                       <i class="fa fa-calendar"></i>
                   </div>
                 </div>
               </div>
             </div>
             <div class="col-md-3">
               <div class="form-group">
                 <div class="input-group date" data-provide="datepicker">
                   <?php
                   $value = Request::get('end_date') ? Request::get('end_date') : null;

                    ?>
                   {{ Form::text('end_date', $value, [
                     'class' => "form-control",
                     'placeholder' => Trans('invoices.end_date'),
                     'autocomplete' => "off"
                   ]) }}
                   <div class="input-group-addon">
                       <i class="fa fa-calendar"></i>
                   </div>
                 </div>
               </div>
             </div>
             <div class="col-md-2">
               <?php
               $selected = Input::get('type') ? Input::get('type') : "all";

                ?>
               {{ Form::select('type', [
                 'all'  =>  trans('dashboard.others.show_all'),
                 'pendding' =>  trans("services.status.pendding"),
                 'repairing' =>  trans('services.status.repairing'),
                 'paid'      => trans('services.status.paid')
               ], $selected, ['class' => "form-control select2"]) }}
             </div>
             <div class="col-md-2">
               <button type="submit" class="btn btn-info pull-right" name="search" value="true"><i class="fa fa-search"></i> {{ Trans('invoices.search') }}</button>
             </div>
           {{ Form::close() }}
         </div>
          </div>
          <div class="box-body">
            <table class="table">
              <thead>
                <tr>
                  <th>{{ trans('services.receipt_no') }}</th>
                  <th>{{ trans('services.duration') }}</th>
                  <th>{{ trans('services.tel') }}</th>
                  <th>{{ trans('services.name') }}</th>
                  <th>{{ trans('services.created_at') }}</th>
                  <th>{{ trans('services.s_status') }}</th>
                  <th style="width: 25%;">{{ trans('dashboard.crud.actions') }}</th>
                </tr>
              </thead>
              <tbody>
              @if (count($services) > 0)
                @foreach ($services as $service) 
                <tr>
                 <td>{{ convertInvoiceNumber($service->id) }}</td>
                 <td>{{ trans('services.durations.'.$service->duration) }}</td>
                 <td>{{ $service->tel }}</td>
                 <td>{{ $service->product_name }} ({{ $service->model }}) @if($service->is_warranty)<span class="label label-default" style="font-weight: normal; padding: 5px;">{{ trans('services.is_warranty') }}</span>@endif @if($service->is_send)<span class="label label-default" style="font-weight: normal; padding: 5px;">{{ trans('services.sent') }}</span>@endif</td>
                 <td>{{ $service->created_at }}</td>
                 <td><div>{{ s_status($service->status) }}</div></td>
                 <td>
                 @if ($service->is_send == false)
                  <div class="modal fade" tabindex="-1" role="dialog" id="myModal{{$service->id}}">
                    <div class="modal-dialog" role="document">
                      <div class="modal-content modal-sm">
                        <div class="modal-header">
                          <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                          <h4 class="modal-title">{{ trans('services.send_product') }}</h4>
                        </div>
                        <div class="modal-body">
                          {{ Form::open(['route' => "services.send"]) }}
                              {{ Form::hidden("service_id",  $service->id) }}
                              <div class="form-group">
                                {{ Form::label('send_date', Trans('services.send_date')) }}
                                <div class="input-group date">
                                  {{ Form::text('send_date', null, [
                                    'class' => "form-control send_date",
                                    'placeholder' => Trans('services.send_date'),
                                    'required'    =>  "required"
                                  ]) }}
                                  <div class="input-group-addon">
                                      <i class="fa fa-calendar"></i>
                                  </div>
                                </div>
                              </div>
                        </div>
                        <div class="modal-footer">
                          <button type="submit" class="btn btn-primary">{{ trans('services.is_send') }}</button>
                        {{ Form::close() }}
                        </div>
                      </div><!-- /.modal-content -->
                    </div><!-- /.modal-dialog -->
                  </div><!-- /.modal -->
                  @endif
                  @if (user_can('repair_service'))
                   <a href="{{ route('services.show', $service->id) }}" class="btn btn-primary btn-xs"><i class="fa fa-th-list"></i> {{ trans('dashboard.others.detail') }}</a>
                  @endif
                  @if (user_can('edit_service'))
                    @if ($service->status == "pendding")
                   <a href="{{ route('services.edit', $service->id)}}" class="btn btn-info btn-xs"><i class="fa fa-edit"></i> {{ trans('dashboard.crud.edit') }}</a>
                   @endif
                  @endif
                  @if (user_can('send_service'))
                   @if ($service->is_send == false && $service->status == "pendding" && $service->is_warranty)
                   <button class="btn btn-success btn-xs" data-toggle="modal" data-target="#myModal{{$service->id}}"><i class="fa fa-send"></i> {{ trans('services.is_send') }}</button>
                   @endif
                  @endif
                  @if (user_can('print_service'))
                    <a href="{{ route('services.print', $service->id)}}" target="_blank" class="btn btn-default btn-xs"><i class="fa fa-print"></i> {{ trans('dashboard.others.print') }}</a>
                  @endif
                 </td>
                </tr>
                @endforeach
              @else 
                <tr>
                  <td colspan="7" class="text-center">
                    {{ trans('services.no_receipt')}}
                  </td>
                </tr>
              @endif
              </tbody>
            </table>
            <div class="text-center">
            {{ $services->appends(Request::except('page'))->links() }}
          </div>
          </div>
        </div>
      </div>
    </div>
  </section>
@endsection
@section('addJs')
  {{ HTML::script('plugins/datepicker/bootstrap-datepicker.js') }}
  {{ HTML::script('plugins/datepicker/locales/bootstrap-datepicker.kh.js') }}
  <script>
   $(function () {
     $('.send_date').datepicker({
      todayHighlight: true,
      format: 'd/m/yyyy',
    });
   });
  </script> 
@endsection