@extends('layouts.production')
@section('content')
  <section class="content-header">
    <h1>
      {{ Trans('services.menu') }}
    </h1>

    <ol class="breadcrumb">
      <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
      <li><a href="{{ route('services.index') }}">{{ Trans('services.menu') }}</a></li>
      <li class="active">{{ $service->exists ? trans('services.edit') : trans('services.create') }}</li>
    </ol>
  </section>
  <!-- Main content -->
  <section class="content">
    @include('layouts.includes.message')
    <div class="row">
      <div class="col-md-6">
        <div class="box">
          <div class="box-header with-border">
            <h3 class="box-title">{{ $service->exists ? trans('services.edit') : trans('services.create') }}</h3>
          </div>
          <div class="box-body">
            {{ Form::model($service, [
              'method' => $service->exists ? "PUT" : "POST",
              'route' => $service->exists ? ['services.update', $service->id] : "services.store"
              ]) }}
             <div class="row">
                <div class="col-md-6">
                  <div class="form-group">
                      {{ Form::label('duration', trans('services.duration')) }}
                      {{ Form::select('duration',[
                          'delay' => trans('services.durations.delay'),
                          '3' => trans('services.durations.3'),
                          '7' =>  trans('services.durations.7'),
                          '10'  => trans('services.durations.10')
                      ],null, ['class' => 'form-control select2', 'required' => 'required', 'placeholder' => trans('services.duration') ]) }}
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="form-group">
                      {{ Form::label('tel', trans('services.tel')) }}
                      {{ Form::text('tel', null, ['class' => 'form-control', 'required' => 'required', 'placeholder' => trans('services.tel') ]) }}
                  </div>
                </div>
              </div>
              <div class="row">
                <div class="col-md-6">
                  <div class="form-group">
                      {{ Form::label('product_name', trans('services.name')) }}
                      {{ Form::text('product_name', null, ['class' => 'form-control', 'required' => 'required', 'placeholder' => trans('services.name') ]) }}
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="form-group">
                      {{ Form::label('model', trans('services.model')) }}
                      {{ Form::text('model', null, ['class' => 'form-control', 'placeholder' => trans('services.model') ]) }}
                  </div>
                </div>
              </div>
             <div class="row">
               <div class="col-md-9">
                 <div class="form-group">
                     {{ Form::label('note', trans('services.note')) }}
                     {{ Form::textarea('note', null, ['class' => 'form-control', 'placeholder' => trans('services.note'), 'rows' => '3' ]) }}
                 </div>
               </div>
               <div class="col-md-3">
                 <div class="checkbox" style="padding-top: 10px;">
                    <label>
                      <input type="checkbox" name="is_warranty" value="1" {{ ($service->is_warranty) ? "checked" : "" }}> {{ trans('services.is_warranty') }}
                    </label>
                  </div>
               </div>
             </div>
           
          </div>
          <div class="box-footer">
            <button type="submit" class="btn btn-success pull-right">{{ trans('dashboard.crud.add') }}</button>
             {{ Form::close() }}
          </div>
        </div>
      </div>
      <div class="col-md-6"></div>
    </div>
  </section>
@endsection
