@extends('layouts.production')
@section('addCss')
  <style>
    .label { font-style: italic; font-weight: normal; padding: 5px; }
  </style>
@endsection
@section('content')
  <section class="content-header">
    <h1>
      {{ Trans('services.menu') }}
    </h1>

    <ol class="breadcrumb">
      <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
      <li>{{ Trans('dashboard.branches.branch') }}</li>
      <li class="active">{{ Trans('dashboard.others.show_all') }}</li>
    </ol>
  </section>
  <!-- Main content -->
  <section class="content">
    @include('layouts.includes.message')
    <div class="row">
      <div class="col-md-12">
        <div class="box">
          <div class="box-header with-border">
            <h3 class="box-title">{{ trans('dashboard.others.show_all') }} </h3>
          </div>
          <div class="box-body">
            <table class="table table-bordered">
              <thead>
                <tr>
                  <th>{{ trans('services.tel') }}</th>
                  <th>{{ trans('services.name') }}</th>
                  <th>{{ trans('services.duration') }}</th>
                  <th>{{ trans('services.s_status') }}</th>
                  <th style="width: 20%;">{{ trans('dashboard.crud.actions') }}</th>
                </tr>
              </thead>
              <tbody>
              @if ($services->getTotal() > 0)
                @foreach ($services as $service)
                <tr>
                  <td>{{ $service->tel }}@if ($service->call > 0) <span class="badge">{{ $service->call }}</span> @endif</td>
                  <td>{{ $service->product_name }}</td>
                  <td>{{ trans('services.durations.'. $service->duration) }}</td>
                  <td>{{ s_status($service->status) }}</td>
                  <td>
                    {{ Form::open(['route' => 'services.callCheckout']) }}
                    {{ Form::hidden('service_id', $service->id) }}
                    @if (user_can('call_service'))
                    <button type="submit" name="call" value="1" class="btn btn-info btn-xs"><i class="fa fa-phone"></i> {{ trans('services.call') }}</button>
                    @endif
                    @if (user_can('checkout_service'))
                    <button type="submit" name="checkout" value="1" class="btn btn-success btn-xs"><i class="fa fa-check"></i> {{ trans('services.checkout') }}</button>
                    @endif
                    {{ Form::close() }}
                  </td>
                </tr>
                @endforeach
              @else 
              <tr>
                <td colspan="5" class="text-center">{{ trans('services.no_receipt') }}</td>
              </tr>
              @endif
              </tbody>
            </table>
            <div class="text-center">
            {{ $services->appends(Request::except('page'))->links() }}
          </div>
          </div>
        </div>
      </div>
    </div>
  </section>
@endsection