@extends('layouts.sale')
	@section('style')
	 <style media="screen">
    legend {
      font-size: 14px;
      margin-bottom: 0px;
    }
    .customer-modal {
      width: 490px !important;
    }
    table#customers-data {
      text-align: left !important;
    }
    #btn-remove-customer {
      margin-top: 10px;
    }
    .changed {
      border: 0;
      background-color: inherit;
      font-size: 22px;
      display: block;
    }
  </style>
	@endsection
	@section('content')
	{{-- @include('sale.inc.data') --}}
	<div class="row">
		<div class="col-sm-12 sale-content">
			<div class="product-list">
				<div class="row"
					<?php
						if(isset($customer)){
							foreach ($customer as $key => $value) {
								echo "data-customer-name=".$value;
								echo " data-customer-id=".$key;
							}
							
						}
					?>
				>
					@if (get_config('style_sale') == "table") 
					<br>
					<div class="col-md-12">
						<table id="example1" class="table table-hover">
            </table>
					</div>
					@else 
						@foreach($productsFromOutlet as $product)
							<a href="#">
								<div class="col-sm-3 col-xs-6 product-item" data-id=" {{ $product->product_id }} ">
									<div class="product-img">
										{{ HTML::image($product->thumbnail) }}
									</div>
									<div class="product-title">
										<p>{{ str_limit($product->name,20) }}<span class="label-info">{{money($product->price)}}</span><br/><span class="clearfix">[{{$product->sku}}]</span></p>
									</div>
								</div>
							</a>
						@endforeach
					<div class="row pagination">
						@unless(count($productsFromOutlet)>16)
		      	 {{	$productsFromOutlet->appends(Request::except('page'))->links() }}
		       	@endunless
				</div>
					@endif
				</div>
			
			</div> <!-- Product lists -->
			<div class="order-list">
			@if (count($draftInvoicesNoTotal) > 0)
				<div class="row">
					<div class="col-md-12">
						{{ Form::open(['method' => 'DELETE', 'route' => 'delete.draftInvoices']) }}
							<button class="btn btn-sm btn-warning"><i class="fa fa-trash"></i> Delete All</button>
            {{ Form::close() }}
            <br>
					</div>
				</div>
			@endif
				<div class="row">
					<?php $colors = ["green","orange","sky-blue"]; ?>
					@foreach($draftInvoices as $invoice)
						<?php $color = $colors[array_rand($colors)]; ?>	
						<a href="{{Route('switchinvoice',$invoice->id)}}">
							<div class="col-sm-2">
								<div class="order-box {{$color}}">
									<div class="order-id">
										#{{ InvoiceHelper::convertInvoiceNumber($invoice->id) }}
									</div>
									<div class="order-price">
										{{getField('Customer','id',$invoice->customer_id,'first_name')}}
										<span>{{ date('Y-d-m',strtotime($invoice->created_at)) }}</span>
									</div>
									<div class="order-name">
										{{ money($invoice->total) }}
									</div>
								</div>
							</div>
						</a>
						
					@endforeach
				</div>
			</div><!-- Order lists -->
		</div> <!-- PAGE CONTENT -->
		@include('sale.inc.sidebar')
	</div>
		@include('sale.inc.modal')
	@endsection
	@section('addJs')
	<script>
    $(function () {
      $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
      });
      $("#example1").DataTable({
        "ajax"        : "{{Route('sale.products')}}",
        "processing"  : true,
        "serverSide"  : true,
        "paging": true,
        "autoWidth": false,
        "columnDefs": [
       		{ "searchable": false, "targets":  [1,7]},
          { 'className': "hidden-md hidden-sm", "targets": [5]},
          { 'className': "limited-width", "targets": [2,3]}
        ],
        "columns": [
            {data: 'sku', name: 'p.sku', orderable: false, title: '{{ Trans('products.sku') }}'},
            {data: 'thumbnail', name: 'p.thumbnail', orderable: false, title: '{{ Trans('products.image') }}'},
            {data: 'name', name: 'p.name',orderable: false,title: '{{ Trans('products.name') }}'},
            {data: 'name_kh', name: 'p.name_kh',orderable: false,title: '{{ Trans('products.name_kh') }}'},
            {data: 'amount', name: 'o.amount',orderable: false,title: '{{ Trans('products.amount') }}'},
            {data: 'price', name: 'p.price',orderable: false,title: '{{ Trans('products.price') }}'},
            {data: 'category', name: 'pc.name',orderable: false,title: '{{ Trans('products.product_category') }}'},
            {data: 'action', name: 'action',orderable: false,title: '{{ Trans('dashboard.crud.actions') }}'},

        ],
        initComplete: function () {
          this.api().columns([1,2,3]).every(function () {
              var column = this;
              var input = document.createElement("input");
              $(input).appendTo($(column.footer()).empty())
              .on('change', function () {
                  var val = $.fn.dataTable.util.escapeRegex($(this).val());
                  column.search(val ? val : '', true, false).draw();
              });
          });
        }
      });
    });
  </script>
	@endsection

	