@extends('layouts.production')
@section('content')
  <section class="content-header">
    <h1>
      {{ Trans('reports.menu') }}
      <small>{{ Trans('reports.transfer') }}</small>
    </h1>
    <ol class="breadcrumb">
      <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
      <li class="active"><a href="#"><i class="fa fa-usd"></i> {{ Trans('reports.menu') }}</a></li>
      <li class="active"><a href="#">{{ Trans('reports.transfer')}}</a></li>
    </ol>
  </section>

  <!-- Main content -->
  <section class="content">
    @if(Session::has('message'))
      <p class="alert alert-warning">
        {{ Trans(Session::get('message')) }}
      </p>
    @endif
    <div class="box box-body">
      {{ Form::open(['method' => 'get', 'class' => '']) }}
        <div class="col-md-3">
          @include('reports.forms.date')
        </div>
        <div class="col-md-3">
          <div class="form-group">
            @include('reports.inc.product_group')
          </div>
          <div class="form-group">
            <label for="">{{Trans('products.operation_type')}}</label>
            <?php
              if(App::getLocale() == "kh") {
                $type = [
                  'all' => trans('reports.all'),
                  'in' => trans('products.in'),
                  'out' => trans('products.out')
                ];
              }
              else {
                $type = [
                  'all' => "All",
                  'in' => "In",
                  'out' => "Out"
                ];
              }
              $selected = Input::get('type') ? Input::get('type') : "";
            ?>
            {{ Form::select('type',$type, $selected, ['class' => 'form-control']) }}
          </div>
        </div>
        <div class="col-md-3">
          <div class="form-group">
            <label for="user">{{ trans('users.users')}}</label>
            <?php
              $selected = Input::get('user') ? Input::get('user') : 'all';
             ?>
            {{ Form::select('user[]', $users, $selected, [
                'class' => 'form-control select2',
                'id'    => 'user',
                'multiple' => true
              ]) }}
          </div>
        </div>
        <div class="col-md-3">
          <div class="form-group pull-right">
            <br>
            <a class="btn btn-default" href="{{ printTransfer() }}" target="_blank"><i class="fa fa-print">{{trans('reports.print')}}</i></a>
            <button type="submit" class="btn btn-info"><i class="fa fa-search"></i> {{ Trans('invoices.search') }}</button>
          </div>
        </div>

        {{ Form::close() }}
        <div class="row">
          <br>
          <div class="col-md-12">
          <br/>
            @if(isset($histories) && count($histories))
              @include('reports.inc.table_transfer')
            @else
              <p class="text-center text-info">
                {{trans('reports.info_product')}}
              </p>
            @endif
          </div>
        </div>
      </div>
  </section>
@endsection
@section('addJs')
  {{ HTML::script('plugins/datepicker/bootstrap-datepicker.js') }}
  {{ HTML::script('plugins/datepicker/locales/bootstrap-datepicker.kh.js') }}
  <script>
    $().datepicker({
      format: 'yyyy-mm-dd',
      language: 'kh'
    });
  </script>
@endsection
