@extends('layouts.production')
@section('content')
    <section class="content-header">
        <h1>
            {{ Trans('reports.menu') }}
            <small>{{ Trans('reports.sub_title') }}</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active"><a href="#"><i class="fa fa-usd"></i> {{ Trans('reports.menu') }}</a></li>
            <li class="active"><a href="#">{{ Trans('reports.sub_title')}}</a></li>
        </ol>
    </section>
    <!-- Main content -->
    <section class="content">
        @if(Session::has('message'))
            <p class="alert alert-warning">
                {{ Trans(Session::get('message')) }}
            </p>
        @endif
        @include('installments.inc.montly_payment')
        <div class="box">
            <div class="box-header with-border">
                <h3 class="box-title">{{ trans("profits.detail") }} - {{ d_format($start) }}</h3>
            </div>
            <div class="box-body">
                <table class="table table-bordered table-striped">
                    <thead>
                    <tr>
                        <th>{{ trans("dashboard.id") }}</th>
                        <th style="width: 20%;">{{ trans('reports.user')}}</th>
                        <th>{{ trans("invoices.menu") }}</th>
                        <th>{{ trans("profits.description") }}</th>
                        <th>{{ trans('reports.profit_types.income')}} </th>
                        <th>{{ trans('reports.profit_types.expense')}} </th>
                    </tr>
                    </thead>
                    <tbody>
                    @if (count($profits) > 0)
                        <?php
                        $i = 1;
                        $totalIncome = 0;
                        $totalExpense = 0;
                        ?>
                        @foreach ($profits as $profit)
                            <?php
                            $totalIncome += $profit->type == "income" ? $profit->amount : 0;
                            $totalExpense += $profit->type == "expense" ? $profit->amount : 0;
                            ?>
                            <tr>
                                <td>{{ $i }}</td>
                                <td>{{ $profit->first_name }} {{ $profit->last_name }}</td>
                                <td>
                                    @if ($profit->installment_id)
                                        <a href="{{ route('installments.show', $profit->installment_id) }}">{{ convertInvoiceNumber($profit->installment_id) }}</a>
                                    @elseif ($profit->mortgage_id)
                                        <a href="{{ route("mortgages.show", $profit->mortgage_id) }}">{{ convertInvoiceNumber($profit->mortgage_id) }}</a>
                                    @else
                                        @if ($profit->receipt_id)
                                            <?php
                                            $payment = DB::table("payments")->where("receipt_id", $profit->receipt_id)->first();
                                            ?>
                                            @if (!empty($payment))
                                                <a href="{{ route('installments.paymentHistory', $payment->id) }}" class="btn btn-sm btn-success btn-payment-history"><i class="fa fa-history"></i></a>
                                            @endif
                                            <?php
                                            $mortgagePayment = DB::table("mortgage_payments")->where("receipt_id", $profit->receipt_id)->first();
                                            ?>
                                                @if (!empty($mortgagePayment))
                                                    <a href="{{ route('mortgage_payments.history', $mortgagePayment->id) }}" class="btn btn-sm btn-success btn-payment-history"><i class="fa fa-history"></i></a>
                                                @endif
                                        @endif
                                    @endif
                                </td>
                                <td>{{ $profit->description }}</td>
                                <td>{{ $profit->type == "income" ? money($profit->amount) : 0 }}</td>
                                <td>{{ $profit->type == "expense" ? money($profit->amount) : 0}}</td>
                            </tr>
                            <?php $i++; ?>
                        @endforeach
                        <tr>
                            <td colspan="4" class="text-right">{{ trans("reports.total") }}</td>
                            <td><strong>{{ money($totalIncome) }}</strong></td>
                            <td><strong>{{ money($totalExpense) }}</strong></td>
                        </tr>
                    @endif
                    </tbody>
                </table>
            </div>
        </div>
    </section>
@endsection
@section("addJs")
    {{ HTML::script("js/loan.js") }}
@endsection