@extends('layouts.production')
@section('content')
  <section class="content-header">
    <h1>
      {{ Trans('reports.menu') }}
      <small>{{ Trans('sale_history.menu') }}</small>
    </h1>
    <ol class="breadcrumb">
      <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
      <li class="active"><a href="#"><i class="fa fa-usd"></i> {{ Trans('reports.menu') }}</a></li>
      <li class="active"><a href="#">{{ Trans('sale_history.menu')}}</a></li>
    </ol>
  </section>

  <!-- Main content -->
  <section class="content">
    @if(Session::has('message'))
      <p class="alert alert-warning">
        {{ Trans(Session::get('message')) }}
      </p>
    @endif
    <div class="box box-body">
        @include('reports.inc.sale_form')
        <div class="row">
          <hr>
          <div class="col-md-12">
            @if(isset($results) && count($results))
              @include('reports.inc.sale_history_table')
            @else
              <p class="text-center">
                {{ trans('sale_history.msg') }}
              </p>
            @endif
            <div class="text-center">
              {{ $results->appends(Request::except('page'))->links() }}
            </div>
          </div>
        </div>
      </div>
  </section>
@endsection
@section('addJs')
  </script>
  {{ HTML::script('plugins/datepicker/bootstrap-datepicker.js') }}
  {{ HTML::script('plugins/datepicker/locales/bootstrap-datepicker.kh.js') }}
  <script>
    $().datepicker({
      format: 'yyyy-mm-dd',
      language: 'kh'
    });
  </script>
@endsection
