@extends('layouts.production')
@section('content')
  <section class="content-header">
    <h1>
      {{ Trans('reports.menu') }}
      <?php
        $title = trans('reports.p_stock_and_warehouse');
        if (Input::get('type') == 'stock') {
          $title = trans('reports.p_stock');
        }
        if (Input::get('type') == 'warehouse') {
          $title = Trans('reports.products_warehouse');
        }

       ?>
      <small>{{ $title }}</small>
    </h1>
    <ol class="breadcrumb">
      <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
      <li class="active"><a href="#"><i class="fa fa-usd"></i> {{ Trans('reports.menu') }}</a></li>
      <li class="active"><a href="#">{{ Trans('reports.products_warehouse')}}</a></li>
    </ol>
  </section>

  <!-- Main content -->
  <section class="content">
    @if(Session::has('message'))
      <p class="alert alert-warning">
        {{ Trans(Session::get('message')) }}
      </p>
    @endif
    <div class="box box-body">
        @include('reports.inc.form_products')
        <div class="row">
          <br>
          <div class="col-md-12">
            @if(isset($results) && count($results))
              @include('reports.inc.pwtable')
              <p class="text-right">Total Products: {{ $results->getTotal() }}</p>
              <div class="text-center">
                {{ $results->appends(Request::except('page'))->links() }}
               </div>
            @else
              <p class="text-center">
                {{ trans('sale_history.msg') }}
              </p>
            @endif
          </div>
        </div>
      </div>
  </section>
@endsection
@section('addJs')
  {{ HTML::script('plugins/datepicker/bootstrap-datepicker.js') }}
  {{ HTML::script('plugins/datepicker/locales/bootstrap-datepicker.kh.js') }}
  <script>
    $().datepicker({
      format: 'yyyy-mm-dd',
      language: 'kh'
    });
  </script>
@endsection
