@extends('layouts.production')
@section('addCss')
  <style media="screen">
  .categories {min-width: 200px;max-width: 250px;}
  </style>
@endsection
@section('content')
  <section class="content-header">
    <h1>
      {{ Trans('reports.menu') }}
      <small>{{ Trans('reports.product_in_out') }}</small>
    </h1>
    <ol class="breadcrumb">
      <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
      <li class="active"><a href="#"><i class="fa fa-usd"></i> {{ Trans('reports.menu') }}</a></li>
      <li class="active"><a href="#">{{ Trans('reports.product_in_out')}}</a></li>
    </ol>
  </section>

  <!-- Main content -->
  <section class="content">
    @if(Session::has('message'))
      <p class="alert alert-warning">
        {{ Trans(Session::get('message')) }}
      </p>
    @endif
    <div class="box box-body">
      {{ Form::open(['method' => 'get', 'class' => 'form-inline']) }}
        @include('Invoices.inc.datetime')
        <div class="form-group categories">
            <?php

              $product_categories = ProductCategory::lists('name','id');
              $product_categories = array_add($product_categories,'All','All Categories');
              $value = Request::get('group') ? Request::get('group') : "All";
             ?>
            {{ Form::select('group[]',$product_categories,$value, [
              'class' => "form-control select2",
              'multiple'  => 'multiple',
              'placeholder' => Trans('products.product_category'),
              'autocomplete' => "off"
            ]) }}
        </div>

      <?php
        if(App::getLocale() == "kh") {
          $type = [
            'all' => trans('reports.all'),
            'in' => trans('products.in'),
            'out' => trans('products.out')
          ];
        }
        else {
          $type = [
            'all' => "All",
            'in' => "In",
            'out' => "Out"
          ];
        }
        $selected = Input::get('type') ? Input::get('type') : "";
        ?>
        {{ Form::select('type',$type, $selected, ['class' => 'form-control']) }}
          <a class="btn btn-default" href="{{ printProducts() }}" target="_blank"><i class="fa fa-print">{{trans('reports.print')}}</i></a>
          <button type="submit" class="btn btn-info pull-right"><i class="fa fa-search"></i> {{ Trans('invoices.search') }}</button>
        {{ Form::close() }}
        <div class="row">
          <br>
          <div class="col-md-12">
            @if(isset($histories) && count($histories))
              @include('reports.inc.table_products')
            @else
              <p class="text-center text-info">
                {{trans('reports.info_product')}}
              </p>
            @endif
          </div>
        </div>

      </div>
  </section>
@endsection
@section('addJs')
  {{ HTML::script('plugins/datepicker/bootstrap-datepicker.js') }}
  {{ HTML::script('plugins/datepicker/locales/bootstrap-datepicker.kh.js') }}
  <script>
    $().datepicker({
      format: 'yyyy-mm-dd',
      language: 'kh'
    });
  </script>
@endsection
