@extends('layouts.report')
@section('style')
  <style media="print">
  @page {size: landscape;}
  </style>
@endsection

@section('header')
  @include('layouts.includes.report_header',[
    'title' => "ផលិតផលលេខកូដជាន់គ្នា",
    'start_date' => $start_date,
    'end_date'  => $end_date
  ])
@endsection

@section('table')
  <br>
  <table class="table">
      <thead>
          <tr>
              <th>{{ trans('products.sku') }}</th>
              <th>{{ trans('products.name') }}</th>
              <th>{{ trans('products.price') }}</th>
              <th>{{ trans('products.price_in') }}</th>
              <th>{{ trans('products.price_wholesale') }}</th>
          </tr>
      </thead>
      <tbody>
          @foreach ($products as $p)
              <tr>
                  <td>{{ $p->sku }}</td>
                  <td>{{ $p->name }}</td>
                  <td>{{ $p->price_in }}</td>
                  <td>{{ $p->price }}</td>
                  <td>{{ $p->price_wholesale }}</td>
              </tr>
          @endforeach

      </tbody>
  </table>
@endsection
