@extends('layouts.production')
@section("addCss")
<style media="screen">
    @media (min-width: 768px){
            .table-responsive {
            overflow-x: hidden;
        }
    }
   
</style>
@endsection
@section('content')
    <section class="content-header">
    <h1>
        {{ Trans('reports.menu') }}
        <small>{{ trans("reports.mortgage_payments") }}</small>
    </h1>
    <ol class="breadcrumb">
        <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
        <li class="active"><a href="#"><i class="fa fa-credit-card"></i> {{ Trans('reports.menu') }}</a></li>
        <li class="active"><a href="#">{{ trans("reports.mortgage_payments") }}</a></li>
    </ol>
    </section>

  <!-- Main content -->
  <section class="content">
    @if(Session::has('message'))
        <p class="alert alert-warning">
            {{ Trans(Session::get('message')) }}
        </p>
    @endif
    <div class="box box-body">
        <div class="row">
            {{ Form::open(['method' => 'get']) }}
            <div class="col-md-4">
                <div class="form-group">
                    <label for="start_date">{{ trans('invoices.start_date')}}</label>
                    <div class="input-group date">
                        <?php
                        $value = Request::get('start_date') ? Request::get('start_date') : null;

                        ?>
                        {{ Form::text('start_date', $value, [
                        'class' => "form-control",
                        'id'    =>  "start_date",
                        'placeholder' => Trans('invoices.start_date'),
                        'autocomplete' => "off"
                        ]) }}
                        <div class="input-group-addon">
                            <i class="fa fa-calendar"></i>
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <label for="end_date">{{ trans('invoices.end_date')}}</label>
                    <div class="input-group date">
                        <?php
                        $value = Request::get('end_date') ? Request::get('end_date') : null;

                        ?>
                        {{ Form::text('end_date', $value, [
                        'class' => "form-control",
                        'id'    =>  "end_date",
                        'placeholder' => Trans('invoices.end_date'),
                        'autocomplete' => "off"
                        ]) }}
                        <div class="input-group-addon">
                            <i class="fa fa-calendar"></i>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label for="">{{ trans("reports.show") }}</label>
                    <?php
                    $selected = Input::get('paginate') ? Input::get('paginate') : 10;
                    ?>
                    {{ Form::select("paginate", [
                        'all'   =>  "All",
                        10      =>  10,
                        15      =>  15,
                        20      =>  20,
                        25      =>  25,
                        30      =>  30,
                        50      =>  50,
                        100     => 100
                    ], $selected, [
                        'class' => 'form-control select2',
                      ]) }}
                </div>
                <div class="form-group">
                    <label for="">{{ trans('users.users')}}</label>
                    <?php
                        $selected = Input::get('user') ? Input::get('user') : 'all';
                    ?>
                    {{ Form::select('user', $users, $selected, [
                        'class' => 'form-control margin select2',
                    ]) }}
                    </div>

            </div>
            <div class="col-md-4">
                <div class="form-group pull-right">
                <br>
                    <button type="submit" class="btn btn-info"><i class="fa fa-search"></i> {{ Trans('invoices.search') }}</button>
                </div>
            </div>
        {{ Form::close() }}
        </div>
        <hr>
        <div class="box box-solid box-primary">
            <div class="box-header">
                <h3 class="box-title">
                    <i class="fa fa-bar-chart"> {{ trans("payments.grahp")}}</i>
                </h3>
            </div>
            <div class="box-body">
                <div class="row">
                    <div class="col-md-6">
                        <div id="canvas-holder" style="width:100%">
                            <canvas id="chart-area" />
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div id="container" style="width: 100%;">
                            <canvas id="canvas-bar"></canvas>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <hr>
            <div class="col-md-12">
                <div class="table-responsive">
                    <table class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>{{ trans("installments.id") }}</th>
                            <th>{{ trans("installments.code") }}</th>
                            <th>{{ trans("payments.payment_date") }}</th>
                            <th>{{ trans("payments.customer") }}</th>
                            <th>{{ trans("payments.total_payment") }}</th>
                            <th>{{ trans("payments.principal") }}</th>
                            <th>{{ trans("payments.interest") }}</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php
                    $i = 1;
                    $totalAmount = 0;
                    $totalLate = 0;
                    $totalPriciple = 0;
                    $totalInterest = 0;

                    ?>
                    @if (count($payments) > 0)

                        @foreach ($payments as $payment)
                            <?php

                            $totalPayment = ($payment->total_amount < $payment->amount) && $payment->is_paid_interest == false ? $payment->total_amount : $payment->amount;
                            $paidPrincipal = $payment->is_paid_interest ? 0 : $payment->principal;
                            $totalAmount += $totalPayment;
                            $totalPriciple += $paidPrincipal;
                            $interest = ($payment->total_amount < $payment->amount) && $payment->is_paid_interest == false ? $payment->amount - $payment->total_amount : $payment->interest;
                            $totalInterest += $interest;
                            ?>
                        <tr>
                            <td>{{ $i }}</td>
                            <td><a href="#"></a>{{ convertInvoiceNumber($payment->id) }}</td>
                            <td>{{ dt_format($payment->fee_date) }}</td>
                            <td>{{ $payment->fullname }} ({{ $payment->tel }})</td>
                            <td>{{ money($totalPayment) }}</td>
                            <td>{{ money($paidPrincipal) }}</td>
                            <td>{{ money($interest) }}</td>
                        </tr>
                        <?php $i++ ?>
                        @endforeach
                        <tr>
                            <td colspan="5" class="text-right">{{ trans("payments.total") }}</td>
                            <td><strong>{{ money($totalPriciple) }}</strong></td>
                            <td><strong>{{ money($totalInterest) }}</strong></td>
                        </tr>
                    @else 
                        <td colspan="8">No Result...</td>
                    @endif
                    </tbody>
                </table>
                </div>
                @if (!empty(Input::get("paginate")) && Input::get("paginate") != "all")
                    <div class="row">
                        <div class="col-md-4">
                            <p style="margin-top: 10px;">Total Records : {{ $payments->getTotal() }} Page {{ $payments->getCurrentPage() }} of {{ $payments->getLastPage() }}</p>
                        </div>
                        <div class="col-md-8 text-right">
                            {{ $payments->appends(Request::except('page'))->links() }}
                        </div>
                    </div>
                @else
                    @if (count($payments) > 0)
                        Total Records : {{ count($payments) }}
                    @endif
                @endif
            </div>
        </div>
      </div>
  </section>
@endsection
@section('addJs')
{{ HTML::script('plugins/datepicker/bootstrap-datepicker.js') }}
{{ HTML::script('plugins/datepicker/locales/bootstrap-datepicker.kh.js') }}
{{ HTML::script("http://www.chartjs.org/dist/2.7.1/Chart.bundle.js") }}
{{ HTML::script("http://www.chartjs.org/samples/latest/utils.js")}}
<script>
    $("#start_date, #end_date").datepicker({
        format: 'dd/mm/yyyy',
        language: 'kh',
        autoclose: true,
        todayHighlight: true
    });
    var randomScalingFactor = function() {
        return Math.round(Math.random() * 100);
    };
    var config = {
        type: 'pie',
        data: {
            datasets: [{
                data: [
                    <?= round($totalPriciple, 2) ?>,  <?= round($totalInterest, 2) ?>
                ],
                backgroundColor: [
                    window.chartColors.yellow,
                    window.chartColors.green
                ],
                label: 'Dataset 1'
            }],
            labels: [
                "{{ trans('reports.principal') }}",
                "{{ trans('reports.interest') }}",
            ]
        },
        options: {
            responsive: true
        }
    };
    var color = Chart.helpers.color;
    var barChart = {
        labels: ["{{ trans('reports.mortgage_payment') }}"],
        datasets: [{
            label: "{{ trans('reports.principal') }}",
            backgroundColor: color(window.chartColors.yellow).alpha(0.5).rgbString(),
            borderColor: window.chartColors.yellow,
            borderWidth: 1,
            data: [
                <?= round($totalPriciple, 2) ?>
            ]
        },
            {
                label: "{{ trans('reports.interest') }}",
                backgroundColor: color(window.chartColors.green).alpha(0.5).rgbString(),
                borderColor: window.chartColors.green,
                borderWidth: 1,
                data: [
                    <?= round($totalInterest, 2) ?>
                ]
            }]
    };
    window.onload = function() {
        var ctx = document.getElementById("chart-area").getContext("2d");
        window.myPie = new Chart(ctx, config);
        var bar = document.getElementById("canvas-bar").getContext("2d");
        window.myBar = new Chart(bar, {
            type: 'bar',
            data: barChart,
            options: {
                responsive: true,
                legend: {
                    position: 'top',
                },
                title: {
                    display: false,
                    text: 'Chart.js Bar Chart'
                }
            }
        });
    };
</script>
@endsection