@extends('layouts.production')
@section('content')
    <section class="content-header">
        <h1>
            {{ Trans('reports.menu') }}
            <small>{{ Trans('reports.sub_title') }}</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active"><a href="#"><i class="fa fa-usd"></i> {{ Trans('reports.menu') }}</a></li>
            <li class="active"><a href="#">{{ Trans('reports.sub_title')}}</a></li>
        </ol>
    </section>
    <!-- Main content -->
    <section class="content">
        @if(Session::has('message'))
            <p class="alert alert-warning">
                {{ Trans(Session::get('message')) }}
            </p>
        @endif
        <div class="box box-body">
            {{ Form::open(['method' => 'get']) }}
            <div class="row">
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="start_date">{{ trans('invoices.start_date') }}</label>
                        <div class="input-group date">
                            <?php
                            $value = Request::get('start_date') ? Request::get('start_date') : null;

                            ?>
                            {{ Form::text('start_date', $value, [
                              'class' => "form-control",
                              'placeholder' => Trans('invoices.start_date'),
                              'autocomplete' => "off",
                              'id' => 'start_date'
                            ]) }}
                            <div class="input-group-addon">
                                <i class="fa fa-calendar"></i>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <label for="start_date">{{ trans('invoices.end_date') }}</label>
                    <div class="form-group">
                        <div class="input-group date">
                            <?php
                            $value = Request::get('end_date') ? Request::get('end_date') : null;

                            ?>
                            {{ Form::text('end_date', $value, [
                              'class' => "form-control",
                              'placeholder' => Trans('invoices.end_date'),
                              'id' => 'end_date',
                              'autocomplete' => "off"
                            ]) }}
                            <div class="input-group-addon">
                                <i class="fa fa-calendar"></i>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="">{{ trans("reports.show") }}</label>
                        <?php
                        $selected = Input::get('paginate') ? Input::get('paginate') : 10;
                        ?>
                        {{ Form::select("paginate", [
                            'all'   =>  "All",
                            10      =>  10,
                            15      =>  15,
                            20      =>  20,
                            25      =>  25,
                            30      =>  30,
                            50      =>  50,
                            100     => 100
                        ], $selected, [
                            'class' => 'form-control select2',
                          ]) }}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="pull-right">
                        <br>
                        <button type="submit" class="btn btn-info" name="search" value="true"><i
                                    class="fa fa-search"></i> {{ Trans('invoices.search') }}</button>
                    </div>
                </div>
            </div>
            {{ Form::close() }}
            <div class="row">
                <br>
                <div class="col-md-12">
                    <table class="table table-striped table-bordered">
                        <thead>
                        <tr>
                            <th style="width: 10%;">{{ trans('products.id') }}</th>
                            <th>{{ trans('reports.created_at')}}</th>
                            <th>{{ trans('reports.profit_types.expense')}} </th>
                            <th>{{ trans('reports.profit_types.income')}} </th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php
                        $totalIncome = 0;
                        $totalExpense = 0;
                        $i = 1;
                        ?>
                        @if (count($profits) > 0)
                            @foreach($profits as $profit)
                                <?php
                                $totalIncome += $profit->totalIncome;
                                $totalExpense += $profit->totalExpense;
                                ?>
                                <tr>
                                    <td>{{ $i }}</td>
                                    <td><a href="{{ route('reports.profits.show', $profit->byDay) }}">{{ d_format($profit->byDay) }}</a></td>
                                    <td>{{ $profit->totalExpense > 0 ? money($profit->totalExpense) : 0}}</td>
                                    <td>{{ $profit->totalIncome > 0 ? money($profit->totalIncome) : 0 }}</td>
                                </tr>
                                <?php $i++; ?>
                            @endforeach
                            <tr>
                                <td class="text-right" colspan="2">{{ trans('reports.total') }}</td>
                                <td><strong>{{money($totalExpense) }}</strong></td>
                                <td><strong>{{ money($totalIncome) }}</strong></td>
                            </tr>
                        @else
                            <tr>
                                <td colspan="5" class="text-center">{{ trans('reports.no_row') }}</td>
                            </tr>
                        @endif
                        </tbody>
                    </table>
                </div>
            </div>
            @if (!empty(Input::get("paginate")) && Input::get("paginate") != "all")
                <div class="row">
                    <div class="col-md-4">
                        <p style="margin-top: 10px;">Total Records : {{ $profits->getTotal() }} Page {{ $profits->getCurrentPage() }} of {{ $profits->getLastPage() }}</p>
                    </div>
                    <div class="col-md-8 text-right">
                        {{ $profits->appends(Request::except('page'))->links() }}
                    </div>
                </div>
            @else
                @if (count($profits) > 0)
                    Total Records : {{ count($profits) }}
                @endif
            @endif
            </div>
        </div>
    </section>
@endsection
@section('addJs')
    {{ HTML::script('plugins/datepicker/bootstrap-datepicker.js') }}
    {{ HTML::script('plugins/datepicker/locales/bootstrap-datepicker.kh.js') }}
    <script>
        $("#start_date, #end_date").datepicker({
            format: 'dd/mm/yyyy',
            language: 'kh',
            autoclose: true,
            todayHighlight: true
        });
    </script>
@endsection
