<table class="table table-striped table-bordered">
    <thead>
    <tr>
        <th style="width: 10%;">{{ trans('products.id') }}</th>
        <th>{{ trans('reports.created_at')}}</th>
        <th>{{ trans('reports.profit_types.expense')}} </th>
        <th>{{ trans('reports.profit_types.income')}} </th>
    </tr>
    </thead>
    <tbody>
    <?php
    $totalIncome = 0;
    $totalExpense = 0;
    $i = 1;
    ?>
    @if (count($profits) > 0)
        @foreach($profits as $profit)
            <?php
            $totalIncome += $profit->totalIncome;
            $totalExpense += $profit->totalExpense;
            ?>
            <tr>
                <td>{{ $i }}</td>
                <td><a href="{{ route('reports.profits.show', $profit->byDay) }}">{{ d_format($profit->byDay) }}</a></td>
                <td>{{ $profit->totalExpense > 0 ? money($profit->totalExpense) : 0}}</td>
                <td>{{ $profit->totalIncome > 0 ? money($profit->totalIncome) : 0 }}</td>
            </tr>
            <?php $i++; ?>
        @endforeach
        <tr>
            <td class="text-right" colspan="2">{{ trans('reports.total') }}</td>
            <td><strong>{{money($totalExpense) }}</strong></td>
            <td><strong>{{ money($totalIncome) }}</strong></td>
        </tr>
    @else
        <tr>
            <td colspan="5" class="text-center">{{ trans('reports.no_row') }}</td>
        </tr>
    @endif
    </tbody>
</table>