<table class="table table-striped table-bordered">
  <thead>
    <tr>
      <th>{{ trans('products.id') }}</th>
      <th>{{ trans('sale_history.sku') }}</th>
      <th>{{ trans('sale_history.name_en')}} </th>
      <th>{{ trans('products.price_in')}}</th>
      <th>{{ trans('sale_history.price')}}</th>
      <th>{{ trans('products.price_wholesale')}}</th>
      <th>{{ trans('products.amount')}}</th>
      <th>{{ trans('sale_history.category')}}</th>
      <th>{{ trans('reports.user')}}</th>
      <th>{{ trans('products.created_at')}}</th>
    </tr>
  </thead>
  <tbody>
    <?php
      $i = 1;
      $amount = 0;
      $total_price_in = 0;
    ?>
    @foreach ($results as $result)
    <tr>
      <td>{{ $i++ }}</td>
      <td>{{ $result->sku }}</td>
      <td>{{ $result->name_en }}</td>
      <td>{{ money($result->price_in) }}</td>
      <td>{{ money($result->price) }}</td>
      <td>{{ money($result->price_wholesale) }}</td>
      <?php 
        $total_price_in += ($result->price_in * $result->amount);
        $amount += $result->amount;
      ?>
      <td>{{ $result->amount }}</td>
      <td>{{ $result->category }}</td>
      <td>{{ $result->first_name }}</td>
      <td>{{ $result->created_at }}</td>
    </tr>
    @endforeach
    @if (!empty(Input::get('print')))
        <tr>
          <td colspan="10" class="text-right">
            {{ trans('products.total_amount') }}
          </td>
          <td>
            {{ $amount }}
          </td>
        </tr>
        <tr>
          <td colspan="10" class="text-right">
            {{ trans('products.total_products') }}
          </td>
          <td>
            {{ count($results) }}
          </td>
        </tr>
         <tr>
          <td colspan="10" class="text-right">
            {{ trans('reports.total_price_in') }}
          </td>
          <td>
            {{ money($total_price_in) }}
          </td>
        </tr>
    @endif
  </tbody>
</table>
