@extends('layouts.production')
@section("addCss")
    <style media="screen">
        @media (min-width: 768px) {
            .table-responsive {
                overflow-x: hidden;
            }
        }

    </style>
@endsection
@section('content')
    <section class="content-header">
        <h1>
            {{ Trans('reports.menu') }}
            <small>Monthly Graph</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active"><a href="#"><i class="fa fa-usd"></i> {{ Trans('reports.menu') }}</a></li>
            <li class="active"><a href="#">Monthly Graph</a></li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        @if(Session::has('message'))
            <p class="alert alert-warning">
                {{ Trans(Session::get('message')) }}
            </p>
        @endif
        <div class="box box-solid box-primary">
            <div class="box-header">
                <h3 class="box-title"><i class="fa fa-line-chart"></i> {{ Trans('dashboard.graph_info') }}</h3>
            </div>
            <div class="box-body">
                <div class="chart-wrapper">
                    <canvas id="canvas" class="chart" height="400px"></canvas>
                </div>

                <!-- JQuery -->
            </div>
        </div>

    </section>
@endsection
@section('addJs')
    {{ HTML::script("http://www.chartjs.org/dist/2.7.1/Chart.bundle.js") }}
    {{ HTML::script("http://www.chartjs.org/samples/latest/utils.js")}}
    <script>
        var MONTHS = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
        var config = {
            type: 'line',
            data: {
                labels: <?= json_encode($chartData['month']) ?>,
                datasets: [{
                    label: "<?= trans('dashboard.monthly_expense') ?>",
                    fill: false,
                    backgroundColor: window.chartColors.yellow,
                    borderColor: window.chartColors.yellow,
                    data: <?= json_encode($chartData["expense"]) ?>,
                }, {
                    label: "<?= trans('dashboard.monthly_priciple') ?>",
                    backgroundColor: window.chartColors.blue,
                    borderColor: window.chartColors.blue,
                    data: <?= json_encode($chartData['priciple']) ?>,
                    fill: false,
                }, {
                    label: "<?= trans('dashboard.monthly_rate') ?>",
                    fill: false,
                    backgroundColor: window.chartColors.red,
                    borderColor: window.chartColors.red,
                    data: <?= json_encode($chartData["rate"]) ?>,
                }]
            },
            options: {
                responsive: true,
                title: {
                    display: false,
                    text: ''
                },
                tooltips: {
                    mode: 'index',
                    intersect: false,
                },
                hover: {
                    mode: 'nearest',
                    intersect: true
                },
                scales: {
                    xAxes: [{
                        display: true,
                        scaleLabel: {
                            display: true,
                            labelString: "<?= trans('dashboard.months') ?>"
                        }
                    }],
                    yAxes: [{
                        display: true,
                        scaleLabel: {
                            display: true,
                            labelString: "<?= trans('dashboard.money') ?>"
                        }
                    }]
                }
            }
        };

        window.onload = function () {
            var ctx = document.getElementById("canvas").getContext("2d");
            window.myLine = new Chart(ctx, config);
        };
    </script>
@endsection