@extends('layouts.production')
@section('content')
  <section class="content-header">
    <h1>
      {{ Trans('reports.menu') }}
      <small>{{ Trans('reports.sub_title') }}</small>
    </h1>
    <ol class="breadcrumb">
      <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
      <li class="active"><a href="#"><i class="fa fa-usd"></i> {{ Trans('reports.menu') }}</a></li>
      <li class="active"><a href="#">{{ Trans('reports.sub_title')}}</a></li>
    </ol>
  </section>
  <!-- Main content -->
  <section class="content">
    @if(Session::has('message'))
      <p class="alert alert-warning">
        {{ Trans(Session::get('message')) }}
      </p>
    @endif
    <div class="box box-body">
      {{ Form::open(['method' => 'get']) }}
      <div class="row">
        <div class="col-md-4">
          <div class="form-group">
            <label for="start_date">{{ trans('invoices.start_date') }}</label>
            <div class="input-group date" data-provide="datepicker">
              <?php
              $value = Request::get('start_date') ? Request::get('start_date') : null;

               ?>
              {{ Form::text('start_date', $value, [
                'class' => "form-control",
                'placeholder' => Trans('invoices.start_date'),
                'autocomplete' => "off"
              ]) }}
              <div class="input-group-addon">
                  <i class="fa fa-calendar"></i>
              </div>
            </div>
          </div>
        </div>
        <div class="col-md-4">
        <label for="start_date">{{ trans('invoices.end_date') }}</label>
          <div class="form-group">
            <div class="input-group date" data-provide="datepicker">
              <?php
              $value = Request::get('end_date') ? Request::get('end_date') : null;

               ?>
              {{ Form::text('end_date', $value, [
                'class' => "form-control",
                'placeholder' => Trans('invoices.end_date'),
                'autocomplete' => "off"
              ]) }}
              <div class="input-group-addon">
                  <i class="fa fa-calendar"></i>
              </div>
            </div>
          </div>
        </div>
        <div class="col-md-3 col-md-offset-1">
          <a class="btn btn-default btn-block" href="{{ printProfits() }}" target="_blank"><i class="fa fa-print">{{trans('reports.print')}}</i></a>
          <button type="submit" class="btn btn-info pull-right btn-block" name="search" value="true"><i class="fa fa-search"></i> {{ Trans('invoices.search') }}</button>
        </div>
      </div>
        {{ Form::close() }}
        <div class="row">
          <br>
          <div class="col-md-12">
            <table class="table table-striped table-bordered">
    <thead>
      <tr>
        <th>{{ trans('products.id') }}</th>
        <th>{{ trans('reports.created_at')}}</th>
        <th>{{ trans('reports.profit_types.income')}} </th>
        <th>{{ trans('reports.profit_types.expense')}} </th>
        <th style="width: 20%;">{{ trans('reports.user')}}</th>
      </tr>
    </thead>
    <tbody>
    <?php
      $totalIncome = 0;
      $totalExpense = 0; 
      $i = 1;
    ?>
    @if (isset($profits) && count($profits) > 0)
      @foreach($profits as $profit) 
      <?php 
          $totalIncome += $profit->totalIncome;
          $totalExpense += $profit->totalExpense;
      ?>
      <tr>
        <td>{{ $i }}</td>
        <td>{{ d_format($profit->byDay) }}</td>
        <td>{{ $profit->totalIncome > 0 ? money($profit->totalIncome) : 0 }}</td>
        <td>{{ $profit->totalExpense > 0 ? money($profit->totalExpense) : 0}}</td>
        <td>{{ getField("User","id",$profit->user_id,"first_name") }}</td>
      </tr>
      <?php $i++; ?>
      @endforeach
    @endif
  
    </tbody>
</table>
          </div>
        </div>
      </div>
  </section>
@endsection
@section('addJs')
  {{ HTML::script('plugins/datepicker/bootstrap-datepicker.js') }}
  {{ HTML::script('plugins/datepicker/locales/bootstrap-datepicker.kh.js') }}
  <script>
    $().datepicker({
      format: 'yyyy-mm-dd',
      language: 'kh'
    });
  </script>
@endsection
