<table class="table table-hover">
  <thead>
    <tr>
      <th>{{ trans('products.id')}}</th>
      <th>{{ trans('products.sku') }}</th>
      <th>{{ trans('products.name')}}</th>
      <th>{{ trans('products.amount')}}</th>
      <th>{{ trans("products.price") }}</th>
      <th style="width: 20%;">{{ trans('sale.total') }}</th>
      @if ($quotation->status == "open" || $quotation->status == "closed") 
      <th style="width:15%;">{{ trans('dashboard.crud.actions') }}</th>
      @endif
    </tr>
  </thead>
  <tbody>
    @if (count($products) > 0)
      <?php
      $total = 0;
      $i = 1;
      $totalQty = 0;
       ?>
      @foreach ($products as $product)
        <?php
         $total += ($product->price * $product->amount);
         $totalQty += $product->amount;
        ?>
        <tr>
          <td>{{ $i++ }}</td>
          <td>{{$product->sku}}</td>
          <td>{{$product->name}}</td>
          <td><input type="number" value="{{$product->amount}}" class="form-control" id="qty-update-{{$product->id}}" data-amount="{{$product->stock_amount}}" min="1"></td>
          <td><input type="number" value="{{$product->price }}" class="form-control" id="qty-price-{{$product->id}}"></td>
          <td>{{money($product->price * $product->amount)}}</td>
          @if ($quotation->status == "open"  ||  $quotation->status == "closed") 
          <td>
            <button type="button" name="button" class="btn btn-success btn-update" data-product-id="{{$product->id}}"><i class="fa fa-edit"></i></button>
            <button type="button" name="button" class="btn btn-danger btn-delete" data-product-id="{{$product->id}}"><i class="fa fa-trash"></i></button>
          </td>
          @endif
        </tr>
      @endforeach
      <tr>
        <td colspan="5" class="text-right"><b>{{ trans('sale.total') }}</b></td>
        <td colspan="2" class="lead">{{ money($total) }}</td>
      </tr>
    @else
      <tr>
        <td colspan="8"​​ class="lead text-center"><div class="no-row">
          {{ trans('quotations.no_product') }}
        </div></td>
      </tr>
    @endif
  </tbody>
</table>