@extends('layouts.production')
@section('addCss')
<style media="screen">
table tr td {
  vertical-align: middle !important;
}
.label { padding: 5px; }
</style>
@endsection
@section('content')
<section class="content-header">
  <h1 id="invoice-id" data-id="{{ $quotation->id }}" data-url="{{ route('loadPreOrder', $quotation->id) }}">
    {{ Trans('quotations.menu') }}
  </h1>
  <ol class="breadcrumb">
    <li><a href="/"><i class="fa fa-dashboard"></i> {{ Trans('dashboard.home') }}</a></li>
    <li><a href="{{ route('customers.index') }}"><i class="fa fa-user-plus"></i> {{ Trans('customers.menu') }}</a></li>
    <li class="active">{{ Trans('quotations.menu') }}</li>
  </ol>
</section>
<!-- Main content -->
<section class="content qurl" data-list-products="{{ route('products.inStock') }}" data-add-product="{{ route('quotations.orders') }}" data-update-product="{{ route('updatePreOrder') }}" data-delete-product="{{ route("deletePreOrder") }}">
@include('layouts.includes.message')
  <div class="row">
    <div class="col-md-4">
      <div class="box">
        <div class="box-header with-border">
          <h3 class="box-title">{{ trans('quotations.show_detail') }}</h3>
        </div>
        <div class="box-body">
          <table class="table table-striped table-bordered">
            @if ($quotation->customer_id)
            <tr>
              <th>{{ trans('customers.menu') }}</th>
              <td>{{ $quotation->first_name }} {{ $quotation->last_name }}</td>
            </tr>
            @endif
             @if ($quotation->tel)
            <tr>
              <th>{{ trans('customers.tel') }}</th>
              <td>{{ $quotation->tel }}</td>
            </tr>
            @endif
             @if ($quotation->address)
            <tr>
              <th>{{ trans('customers.address') }}</th>
              <td>{{ $quotation->address }}</td>
            </tr>
            @endif
            <tr>
              <th>{{ trans('quotations.quot_no') }}</th>
              <td>{{ convertInvoiceNumber($quotation->id) }}</td>
            </tr>
            <tr>
              <th>{{ trans('invoices.status') }}</th>
              <td>{{ quot_status($quotation->status) }}</td>
            </tr>
            <tr>
              <th>{{ trans('quotations.date') }}</th>
              <td> {{ $quotation->created_at }}</td>
            </tr>
          </table>
        </div>
      </div>
    </div>
    <div class="col-md-8">
       <div class="box">
         <div class="box-header with-border">
           <h3 class="box-title">{{ trans('products.product') }}</h3>
         </div>
         <!-- /.box-header -->
        <div class="box-body" id="load-preorders">
        </div>
        <div class="box-footer">
          {{ Form::open(['route' => 'quotations.toInvoice']) }}
          {{ Form::hidden('quotation_id', $quotation->id) }}
          @if ($quotation->status == "closed")
          <button class="btn btn-default btn-sm" type="submit" name="btn-cancel" value="1"><i class="fa fa-exclamation-triangle"></i> {{ trans('dashboard.crud.cancel') }}</button>
          @endif
           <button class="btn btn-primary btn-sm pull-right" type="submit" {{ $quotation->status == "approved" || $quotation->status == "cancel" ? 'disabled="disable"': ""}}><i class="fa fa-check-circle"></i> {{ trans('quotations.approved') }}</button>
          {{ Form::close() }}
        </div>
       </div>
    </div>
  </div>
</section>
@endsection
@section('addJs')
{{ HTML::script('production/js/quotation.js') }}
  <script>
    $(function() {
      quotation.loadProduct();
      quotation.listPinStock();
      quotation.editProductAmount();
      quotation.deleteProduct();
    });
  </script>
@endsection