@extends('layouts.production')
@section('addCss')
<style media="screen">
input[type=number].form-control {
 width: 50%;
}
table tr td {
  vertical-align: middle !important;
}
.label { padding: 5px; }
</style>
@endsection
@section('content')
<section class="content-header">
  <h1>
    {{ Trans('quotations.menu') }}
    <small>{{ Trans('customers.show') }}</small>
  </h1>
  <ol class="breadcrumb">
    <li><a href="/"><i class="fa fa-dashboard"></i> {{ Trans('dashboard.home') }}</a></li>
    <li><a href="{{ route('customers.index') }}"><i class="fa fa-user-plus"></i> {{ Trans('customers.menu') }}</a></li>
    <li class="active">{{ Trans('quotations.menu') }}</li>
  </ol>
</section>
<!-- Main content -->
<section class="content">
@include('layouts.includes.message')
  <div class="row">
    <div class="col-md-12">
      <div class="box">
        <div class="box-header with-border">
         <div class="row">
           {{ Form::open(['method' => 'get']) }}
           <div class="col-md-2">
             <div class="form-group">
               <?php
               $value = Request::get('invoice_id') ? Request::get('invoice_id') : null;

                ?>
               {{ Form::text('invoice_id', $value, [
                 'class' => 'form-control',
                 'placeholder' =>  trans('invoices.id')
               ]) }}
             </div>
           </div>
             <div class="col-md-3">
               <div class="form-group">
                 <div class="input-group date" data-provide="datepicker">
                   <?php
                   $value = Request::get('start_date') ? Request::get('start_date') : null;

                    ?>
                   {{ Form::text('start_date', $value, [
                     'class' => "form-control",
                     'placeholder' => Trans('invoices.start_date'),
                     'autocomplete' => "off"
                   ]) }}
                   <div class="input-group-addon">
                       <i class="fa fa-calendar"></i>
                   </div>
                 </div>
               </div>
             </div>
             <div class="col-md-3">
               <div class="form-group">
                 <div class="input-group date" data-provide="datepicker">
                   <?php
                   $value = Request::get('end_date') ? Request::get('end_date') : null;

                    ?>
                   {{ Form::text('end_date', $value, [
                     'class' => "form-control",
                     'placeholder' => Trans('invoices.end_date'),
                     'autocomplete' => "off"
                   ]) }}
                   <div class="input-group-addon">
                       <i class="fa fa-calendar"></i>
                   </div>
                 </div>
               </div>
             </div>
             <div class="col-md-2">
               <?php
               $selected = Input::get('type') ? Input::get('type') : "all";

                ?>
               {{ Form::select('type', [
                 'all' =>  trans('dashboard.others.show_all'),
                 'closed' =>  trans('quotations.status.closed'),
                 'approved' =>  trans('quotations.status.approved'),
               ], $selected, ['class' => "form-control select2"]) }}
             </div>
             <div class="col-md-2">
               <button type="submit" class="btn btn-info pull-right" name="search" value="true"><i class="fa fa-search"></i> {{ Trans('invoices.search') }}</button>
             </div>
           {{ Form::close() }}
         </div>
        </div>
        <div class="box-body">
          <table class="table">
            <thead>
              <tr>
                <th>{{ trans('quotations.quot_no') }}/ N<sup>0</sup></th>
                <th>{{ trans('customers.menu') }}</th>
                <th>{{ trans('invoices.status') }}</th>
                <th>{{ trans('quotations.date') }}</th>
                <th style="width:25%">{{ trans('dashboard.crud.actions') }}</th>
              </tr>
            </thead>
            <tbody>
            @if (count($quotations) > 0)
              @foreach ($quotations as $q)
                <tr>
                  <td>{{ convertInvoiceNumber($q->id) }}</td>
                  <td>{{ get_c_q($q->id) }}</td>
                  <td>{{ quot_status($q->status) }}</td>
                  <td>{{ $q->created_at }}</td>
                  <td>
                    <a href="{{ route('quotations.show', $q->id) }}" class="btn btn-default btn-xs"><i class="fa fa-th-list"></i> {{ trans("dashboard.others.show") }}</a>
                    <a href="{{ route('printQuotation', $q->id) }}" target="_blank" class="btn btn-primary btn-xs"><i class="fa fa-print"></i>{{ trans("dashboard.others.print") }}</a>
                    <a href="#" class="btn btn-xs btn-danger" data-toggle="modal" data-target="#myModal{{$q->id}}"><i class="fa fa-trash"></i> {{Trans("dashboard.crud.remove")}}</a>
                    @include('layouts.includes.modals.danger', ['model' => $q,'toRoute'=>'quotations','attribute'=>'id'])
                  </td>
                </tr>
              @endforeach
            @else 
            <tr>
              <td colspan="5" class="text-center alert-warning">No Quotation</td>
            </tr>
            @endif
            </tbody>
          </table>
          <div class="text-center">
            {{ $quotations->appends(Request::except('page'))->links() }}
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
@endsection