@extends('layouts.production')
@section('addCss')
<style media="screen">
input[type=number].form-control {
 width: 50%;
}
</style>
@endsection
@section('content')
<section class="content-header">
  <h1>
    {{ Trans('quotations.menu') }}
    <small>{{ Trans('customers.show') }}</small>
  </h1>
  <ol class="breadcrumb">
    <li><a href="/"><i class="fa fa-dashboard"></i> {{ Trans('dashboard.home') }}</a></li>
    <li><a href="{{ route('customers.index') }}"><i class="fa fa-user-plus"></i> {{ Trans('customers.menu') }}</a></li>
    <li class="active">{{ Trans('quotations.menu') }}</li>
  </ol>
</section>
<!-- Main content -->
<section class="content">
@include('layouts.includes.message')
@include('quotations.inc')
<div class="row">
  <div class="col-md-4">
    <div class="box">
      <div class="box-header with-border">
        <h3 class="box-title">
          {{ trans('dashboard.others.show_all') }}
        </h3>
      </div>
      {{ Form::open(['method' => "POST", 'route' => "quotations.new.post" ]) }}
      <!-- /.box-header -->
      <div class="box-body">
        <div class="form-group">
            {{ Form::label('customer_id', Trans('customers.menu')) }}
            <div class="input-group">
              {{ Form::select('customer_id', $customers, 'none', ['class' => 'select2  form-control', 'id' => 'customer_id']) }}
              <span class="input-group-btn">
                <a class="btn btn-default" id="add_customer" title="Add New Customer" data-toggle="modal" data-target="#customerModal"><i class="glyphicon glyphicon-plus"></i></a>
              </span>
            </div>
          </div>
      </div>
      <!-- /.box-body -->
      <div class="box-footer">
        <button class="btn btn-success pull-right">{{ trans('dashboard.crud.add') }}</button>
        {{ Form::close() }}
      </div>
    </div>
      <!-- /.box -->
  </div>
</div>
</section>
@endsection
@section('addJs')
  <script>
    /**
     * Add new Customer
     */
    $("#customerModal").on('shown.bs.modal', function () {
        $("#first_name").focus();
    });
     $("#form-add-customer").submit(function (e) {
        e.preventDefault();
        $.ajax({
            url: $("#form-add-customer").attr('action'),
            type: "POST",
            data: $("#form-add-customer").serialize(),
            success : function (data) {
                console.log(data);
                toastr.options = {
                  "progressBar": false,
                  "positionClass": "toast-bottom-left",
                  "hideMethod": "fadeOut"
                }
                if(data.error == true) {
                  toastr.error(data.msg);
                } else {
                  $('#customerModal').modal('hide');
                  var newOption = new Option(data.customer.first_name + " " + data.customer.last_name, data.customer.id, true, true);
                  $("#customer_id").append(newOption).trigger('change');
                  toastr.success(data.msg);
                }
            }
        });
     });
  </script>
@endsection
