<!--Customer Modal-->
<div class="modal fade" id="customerModal" tabindex="-1" role="dialog">
  <div class="modal-dialog modal-md" id="dialog" role="document" style="padding-top:20px;">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title">{{ trans('customers.add_new') }}</h4>
      </div>
      {{ Form::open([ 'method' => 'post', 'action' => 'sale.new_customerQuotation', 'id' => 'form-add-customer']) }}
      <div class="modal-body">
        <div class="row">
          <div class="col-md-6">
            <div class="form-group{{ $errors->has('first_name') ? ' has-error' : '' }}">
                {{ Form::label('first_name', trans('customers.first_name')) }}
                {{ Form::text('first_name', null, ['class' => 'form-control', 'placeholder' => trans('customers.first_name')]) }}
                <small class="text-danger">{{ $errors->first('first_name') }}</small>
            </div>
          </div>
          <div class="col-md-6">
            <div class="form-group{{ $errors->has('last_name') ? ' has-error' : '' }}">
                {{ Form::label('last_name', trans('customers.last_name')) }}
                {{ Form::text('last_name', null, ['class' => 'form-control', 'required' => 'required', 'placeholder' => trans('customers.last_name')]) }}
                <small class="text-danger">{{ $errors->first('last_name') }}</small>
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col-md-12">
            <div class="form-group{{ $errors->has('tel') ? ' has-error' : '' }}">
                {{ Form::label('tel', trans('customers.tel')) }}
                {{ Form::text('tel', null, ['class' => 'form-control', 'placeholder' => trans('customers.tel')]) }}
                <small class="text-danger">{{ $errors->first('tel') }}</small>
            </div>
          </div>
          <div class="col-md-12">
            <div class="form-group{{ $errors->has('first_name') ? ' has-error' : '' }}">
                {{ Form::label('address', trans('customers.address')) }}
                {{ Form::textarea('address', null, ['class' => 'form-control', 'rows' => '3', 'placeholder' => trans('customers.address')]) }}
                <small class="text-danger">{{ $errors->first('address') }}</small>
            </div>
          </div>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">{{ trans('dashboard.crud.cancel') }}</button>
        <button type="submit" class="btn btn-primary">{{ trans('dashboard.crud.add') }}</button>
      </div>
      {{ Form::close() }}
    </div><!-- /.modal-content -->
  </div><!-- /.modal-dialog -->
</div><!-- /.modal -->